# Configuration

2024-10-29 화

## 1. Ubuntu, Debian

<https://www.debian.org/distrib/packages>

~~~sh
# Development Tools
apt install -y build-essential gdb | tee ~/apt/apt_install_24102411_build-essential,gdb.txt

# dependencies
apt install -y libexpat1-dev libssl-dev | tee ~/apt/apt_install_24102411_libexpat1-dev,libssl-dev.txt
apt install -y libmariadb-dev-compat | tee ~/apt/apt_install_24112111_libmariadb-dev-compat.txt
apt install -y libecpg-dev | tee ~/apt/apt_install_25040908_libecpg-dev.txt
# runtime only see. apt info libecpg6

# FIX libaio1t64
ln -s /usr/lib/x86_64-linux-gnu/libaio.so.1t64.0.2 /usr/lib/x86_64-linux-gnu/libaio.so.1

# build for httpd-2.4
apt install -y libapr1-dev libaprutil1-dev | tee ~/apt/apt_install_24121117_libapr1-dev,libaprutil1-dev.txt
apt install -y libpcre2-dev | tee ~/apt/apt_install_24121117_libpcre2-dev.txt

apt install -y clang | tee ~/apt/apt_install_25060313_clang.txt
~~~

### sshfs

~~~sh
apt install -y sshfs | tee ~/apt/apt_install_24102515_sshfs.txt

# .profile
export SSH_AUTH_SOCK="/run/user/$(id -u)/keyring/ssh"
[ -d $(dirname ${SSH_AUTH_SOCK}) ] || mkdir -p $(dirname ${SSH_AUTH_SOCK})

echo
echo 'Do it'
echo "ssh-agent -a ${SSH_AUTH_SOCK}; ssh-add"
echo 'sshfs daejung@g01r09:/home/daejung/work/dcl /home/daejung/work/dcl'
~~~

## 2. Rocky, RedHat, Fedora

<https://www.rpmfind.net/>

~~~sh
# Development Tools
dnf group info development

dnf group install -y development | tee ~/dnf/dnf_group_install_24102913_development.txt

# dependeicies
dnf install -y expat-devel openssl-devel | tee ~/dnf/dnf_install_24102913_expat-devel,openssl-devel.txt

dnf install -y mariadb-connector-c-devel | tee ~/dnf/dnf_install_24111014_mariadb-connector-c-devel.txt

dnf install -y libecpg-devel | tee ~/dnf/dnf_install_25042117_libecpg-devel.txt
# runtime only see. dnf info libecpg

# build for httpd-2.4
dnf install -y apr-devel apr-util-devel | tee ~/dnf/dnf_install_24121117_apr-devel,apr-util-devel.txt
dnf install -y pcre2-devel | tee ~/dnf/dnf_install_24121117_pcre2-devel.txt

dnf install -y clang | tee ~/dnf/dnf_install_25062211_clang.txt
~~~

### cifs

~~~sh
dnf install -y cifs-utils | tee ~/dnf/dnf_install_23062009_cifs-utils.txt

mkdir /root/cloud-k8s

vi /etc/fstab
//n0317ud70p/work/cpp/dcl /home/work/cpp/dcl cifs ro,noauto,user   0 0

systemctl daemon-reload
mount -a
df

apt install -y cifs-utils | tee ~/apt/apt_install_24112115_cifs-utils.txt
~~~

## 3. VSCode

[C/C++ Extension Pack](https://marketplace.visualstudio.com/items?itemName=ms-vscode.cpptools)

## 4. Predefined macros

~~~sh
# clang
clang -dM -E -x c /dev/null
# gcc
cpp -dM -E /dev/null
# msvc
cl /PD /Zc:preprocessor /E a.c
~~~

## 5. Visual Studio

~~~sh
REM 2024-11-14 목, 2025-04-29 화

set EXPAT_INCL=D:\Work\sdn\build\expat-win32bin-2.6.3\Source\lib
set APACHE=D:\Opt\Apache24

set FIREBIRD=D:\Opt\Firebird
set INFORMIXDIR=D:\Opt\informix
set INTERBASE=D:\Opt\InterBase
set MARIADB=D:\Opt\mariadb-connector-c-3.4.3
set ORACLE_HOME=D:\Opt\oracle21_client_home
set POSTGRESQL=D:\Opt\PostgreSQL17
set MEDIAINFO=C:\Program Files\MediaInfo

set Ext_IncludePath=%EXPAT_INCL%
set Ext_LibraryPath=%FIREBIRD%\lib;%INFORMIXDIR%\lib;%INTERBASE%\SDK\lib_ms;%MARIADB%\lib64;%ORACLE_HOME%\oci\lib\msvc;%POSTGRESQL%\lib;%APACHE%\lib

set BuildOut=D:\Work\sdn\build\x64\lib
set Path=%Path%;%BuildOut%;%FIREBIRD%;%INFORMIXDIR%\bin;%INTERBASE%\bin;%MARIADB%\lib64;%ORACLE_HOME%\bin;%POSTGRESQL%\bin;%MEDIAINFO%

cd D:\Work\sdn\build\x64\bin

"C:\Program Files\Microsoft Visual Studio\2022\Community\Common7\IDE\devenv.exe"
~~~

~~~sh
# 32bit
cd D:\Work\sdn\build\Win32\bin
set BuildOut=D:\Work\sdn\build\Win32\lib
set Path=%Path%;%BuildOut%

set Path=%Path%;"C:\Program Files\Microsoft Visual Studio\2022\Community\VC\Tools\MSVC\14.42.34433\bin\Hostx64\x86"

set Path=%Path%;"C:\Program Files\Microsoft Visual Studio\2022\Community\VC\Tools\MSVC\14.42.34433\bin\Hostx64\x64"

set Path=%Path%;"C:\Program Files\Microsoft Visual Studio\2022\Community\VC\Tools\MSVC\14.42.34433\bin\Hostx86\x86"

set Path=%Path%;"C:\Program Files\Microsoft Visual Studio\2022\Community\VC\Tools\MSVC\14.42.34433\bin\Hostx86\x64"
~~~

## 6. MinGW

Minimalist GNU for Windows

<https://www.mingw-w64.org/>

<https://code.visualstudio.com/docs/cpp/config-mingw>

[MSYS2](https://www.msys2.org/)

<https://github.com/msys2/msys2-installer/releases/download/2025-02-21/msys2-x86_64-20250221.exe>

~~~sh
# UCRT64
pacman -S mingw-w64-ucrt-x86_64-gcc | tee ~/pacman/sync_25060216_mingw-w64-ucrt-x86_64-gcc.txt

pacman -Q --info mingw-w64-ucrt-x86_64-gcc

pacman -S --needed base-devel mingw-w64-ucrt-x86_64-toolchain

pacman -S mingw-w64-ucrt-x86_64-expat
pacman -S mingw-w64-ucrt-x86_64-apr mingw-w64-ucrt-x86_64-apr-util

pacman -S mingw-w64-ucrt-x86_64-libmariadbclient
pacman -S mingw-w64-ucrt-x86_64-postgresql

mkdir ucrt; cd ucrt; ${DCL_SOURCE_ROOT}/configure; make

export APACHE=/d/opt/apache24
export FIREBIRD=/d/opt/firebird
export INFORMIXDIR=/d/opt/informix
export INTERBASE=/d/opt/interbase
export ORACLE_HOME=/d/opt/oracle21_client_home
export MEDIAINFO="/c/Program Files/MediaInfo"

export PATH=${PATH}:~/ucrt/lib:${INFORMIXDIR}/bin:${MEDIAINFO}

cd ~/ucrt/lib

gendef ${APACHE}/bin/libhttpd.dll
dlltool -D ${APACHE}/bin/libhttpd.dll -d libhttpd.def -l libhttpd.dll.a

cp -a ${FIREBIRD}/fbclient.dll .
gendef fbclient.dll
dlltool -D fbclient.dll -d fbclient.def -l fbclient.dll.a

cp -a ${INTERBASE}/bin/ibclient64.dll .
gendef ibclient64.dll
dlltool -D ibclient64.dll -d ibclient64.def -l ibclient64.dll.a

gendef ${INFORMIXDIR}/bin/igl4n304.dll
gendef ${INFORMIXDIR}/bin/iglxn304.dll
gendef ${INFORMIXDIR}/bin/igo4n304.dll
gendef ${INFORMIXDIR}/bin/isqlt09a.dll
dlltool -D ${INFORMIXDIR}/bin/igl4n304.dll -d igl4n304.def -l igl4n304.dll.a
dlltool -D ${INFORMIXDIR}/bin/iglxn304.dll -d iglxn304.def -l iglxn304.dll.a
dlltool -D ${INFORMIXDIR}/bin/igo4n304.dll -d igo4n304.def -l igo4n304.dll.a
dlltool -D ${INFORMIXDIR}/bin/isqlt09a.dll -d isqlt09a.def -l isqlt09a.dll.a

cp -a ${ORACLE_HOME}/bin/oci.dll .
cp -a ${ORACLE_HOME}/instantclient/light/oraociicus.dll .
gendef oci.dll
dlltool -D oci.dll -d oci.def -l oci.dll.a

# CLANG64
pacman -S mingw-w64-clang-x86_64-clang | tee ~/pacman/sync_25060216_mingw-w64-clang-x86_64-clang.txt

pacman -Q --info mingw-w64-clang-x86_64-clang mingw-w64-clang-x86_64-make

pacman -S --needed base-devel mingw-w64-clang-x86_64-toolchain

pacman -S mingw-w64-clang-x86_64-expat
pacman -S mingw-w64-clang-x86_64-apr mingw-w64-clang-x86_64-apr-util

pacman -S mingw-w64-clang-x86_64-libmariadbclient

pacman -S mingw-w64-clang-x86_64-postgresql

mkdir clang; cd clang; ${DCL_SOURCE_ROOT}/configure; CC=clang make

export APACHE=/d/opt/apache24
export FIREBIRD=/d/opt/firebird
export INFORMIXDIR=/d/opt/informix
export INTERBASE=/d/opt/interbase
export ORACLE_HOME=/d/opt/oracle21_client_home
export MEDIAINFO="/c/Program Files/MediaInfo"

export PATH=${PATH}:~/clang/lib:${INFORMIXDIR}/bin:${MEDIAINFO}

cd ~/clang/lib
cp ../../ucrt/lib/*.def .

# gendef ${APACHE}/bin/libhttpd.dll
dlltool -D ${APACHE}/bin/libhttpd.dll -d libhttpd.def -l libhttpd.dll.a

cp -a ${FIREBIRD}/fbclient.dll .
# gendef fbclient.dll
dlltool -D fbclient.dll -d fbclient.def -l fbclient.dll.a

cp -a ${INTERBASE}/bin/ibclient64.dll .
# gendef ibclient64.dll
dlltool -D ibclient64.dll -d ibclient64.def -l ibclient64.dll.a

# gendef ${INFORMIXDIR}/bin/igl4n304.dll
# gendef ${INFORMIXDIR}/bin/iglxn304.dll
# gendef ${INFORMIXDIR}/bin/igo4n304.dll
# gendef ${INFORMIXDIR}/bin/isqlt09a.dll
dlltool -D ${INFORMIXDIR}/bin/igl4n304.dll -d igl4n304.def -l igl4n304.dll.a
dlltool -D ${INFORMIXDIR}/bin/iglxn304.dll -d iglxn304.def -l iglxn304.dll.a
dlltool -D ${INFORMIXDIR}/bin/igo4n304.dll -d igo4n304.def -l igo4n304.dll.a
dlltool -D ${INFORMIXDIR}/bin/isqlt09a.dll -d isqlt09a.def -l isqlt09a.dll.a

cp -a ${ORACLE_HOME}/bin/oci.dll .
cp -a ${ORACLE_HOME}/instantclient/light/oraociicus.dll .
# gendef oci.dll
dlltool -D oci.dll -d oci.def -l oci.dll.a
~~~
