#ifndef __DCL_ARGUMENTS_H__
#define __DCL_ARGUMENTS_H__     20250128

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_ARRAY_H__
#include <dcl/Array.h>
#endif
#ifndef __DCL_WRITER_H__
#include <dcl/Writer.h>
#endif

__DCL_BEGIN_NAMESPACE

class DCLCAPI Arguments : public Object
{
	DECLARE_CLASSINFO(Arguments)
public:
	struct Option
	{
		const wchar_t* name;
		int            key;
		const wchar_t* arg;
		int            flags;
		const wchar_t* doc;
	};

	Arguments(
		Writer& _output, Writer& _errout,
		const wchar_t* _program_version,
		const wchar_t* _program_bug_address,
		const wchar_t* _arg_doc,
		const wchar_t* _doc,
		const Option   _options[]
	);

	bool parse(
		int _argc, char* _argv[], bool _argv_required = true
	);

	Writer& output() const {
		return __output;
	}

	Writer& errout() const {
		return __errout;
	}

	const String& value0() const {
		return __value0;
	}

	const StringArray& values() const {
		return __values;
	}

protected:
	virtual void onOption(int _key, const String& _arg)
		__DCL_THROWS1(Exception*);

	virtual String onValidate();

private:
	Writer&		__output;
	Writer&		__errout;

	String		__value0;
	StringArray	__values;

	const wchar_t* __program_version;
	const wchar_t* __program_bug_address;
	const wchar_t* __arg_doc;
	const wchar_t* __doc;
	const Option*  __options;

public:
	String help() const;
	String shortUsage() const;
	String tryUsage() const;
	String argRequired(const String& _option) const;
	String usage() const;
	String version() const;
};

__DCL_END_NAMESPACE

#endif	// __DCL_ARGUMENTS_H__
