#ifndef __DCL_ARRAY_H__
#define __DCL_ARRAY_H__			20110308

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

__DCL_BEGIN_NAMESPACE

#define __DCL_INTERNAL__

// class DCLCAPI StringArray
#define __COMPILE_StringArray__			1
#include "__ARRAY.h"
#undef __COMPILE_StringArray__

// class DCLCAPI ByteStringArray
#define __COMPILE_ByteStringArray__		1
#include "__ARRAY.h"
#undef __COMPILE_ByteStringArray__

// class DCLCAPI PointerArray
#define __COMPILE_PointerArray__		1
#include "__ARRAY.h"
#undef __COMPILE_PointerArray__

struct DCLCAPI StringString
{
	String		key;
	String		value;

	StringString() {}

	StringString(const String& key, const String& value)
	{
		this->key = key;
		this->value = value;
	}

	const StringString& operator=(const StringString& _src)
	{
		this->key = _src.key;
		this->value = _src.value;
		return *this;
	}

	const String toString() const
	{
		StringBuilder r = __T("\"");
		r += key;
		r += __T("\", \"");
		r += value;
		r += __T("\"");
		return r;
	}
};

inline bool operator == (const StringString& _x, const StringString& _y)
{
	return _x.key == _y.key;
}

// class DCLCAPI StringStringArray
#define __COMPILE_StringStringArray__		1
#include "__ARRAY.h"
#undef __COMPILE_StringStringArray__

#undef __DCL_INTERNAL__

__DCL_END_NAMESPACE

#endif		// __DCL_ARRAY_H__
