#ifndef __DCL_BYTES_INPUT_STREAM_H__
#define __DCL_BYTES_INPUT_STREAM_H__	20080606

#ifndef __DCL_INPUT_STREAM_H__
#include <dcl/InputStream.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * {@link ByteString} 으로부터 바이트 단위의 스트림 데이터를 읽는다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		ByteString
 */
class DCLCAPI BytesInputStream : public InputStream
{
	DECLARE_CLASSINFO(BytesInputStream)
public:
	/**
	 * 스트림에 대한 간략한 요약을 반환한다.
	 */
	virtual String toString() const;

	/**
	 * ByteString으로부터 스트림 객체를 구성하다.
	 */
	BytesInputStream(const ByteString& _str);

	/**
	 * 읽기 가능한 전체 바이트 수를 반환한다.
	 */
	virtual size_t available() const
			__DCL_THROWS1(IOException*);

	/**
	 * 스트림으로부터 데이터를 읽는다.
	 * @param _buf
	 *		버퍼
	 * @param _n
	 *		버퍼의 크기가 _n바이트
	 * @return
	 *		읽은 바이트의 수이다. 0이면 EOF이다.
	 */
	virtual size_t read(void* _buf, size_t _n) 
			__DCL_THROWS1(IOException*);

protected:
	ByteString		__str;
	const char*		__begin;
	const char*		__end;
};

__DCL_END_NAMESPACE

#endif		// __DCL_BYTES_INPUT_STREAM_H__
