#ifndef __DCL_CONFIG_H__
#define __DCL_CONFIG_H__		20110105

/*****************************************************
	OPERATING SYSTEM CONFIG
*****************************************************/

#if defined(_WIN32) || defined(_WIN64)
	#ifndef _WIN32_WINNT
		#define _WIN32_WINNT	0x0600
	#endif	
	#define __DCL_WINDOWS		1
	#define __DCL_UNIX			0
	#define __DCL_PTHREAD		0
	#define __DCL_USE_OPENSSL	0
	#define __DCL_USE_SCHANNEL	1
#elif defined(unix) || defined(__unix) || defined(__unix__) || defined(linux)
	#define __DCL_WINDOWS		0
	#define __DCL_UNIX			1
	#define __DCL_PTHREAD		1
	#define __DCL_USE_OPENSSL	1
	#define __DCL_USE_SCHANNEL	0
#else
	#error "Not Supported OS!"
#endif

#if defined(_DEBUG) || defined(__DCL_DEBUG)
	#undef __DCL_DEBUG
	#define __DCL_DEBUG			1
#endif

/*****************************************************
	COMPILE CONFIG
*****************************************************/

/*
 * MSC로 Static Library 에서 최적화 하면 LibMain::__LibInitializer 코드가 생성되지 않는다
 * 2011-04-26
 */
#define __DCL_HAVE_MANUAL_INITIALIZE		1

#if __DCL_DEBUG
	#define __DCL_HAVE_THIS_FILE__			1
	#define __DCL_HAVE_ALLOC_DEBUG			1	/* core/Object.h	*/
	#define __DCL_HAVE_STRING_ALLOC_DEBUG	0	/* core/String.cpp:1039	*/
#endif

#define __DCL_HAVE_NAMESPACE				1
#define __DCL_HAVE_THROWS_SPEC				0

#if __DCL_DEBUG
	/* 디버그 버전에서 AssertError*가 throw 될 수 있다. GCC에서
	   예외의 type이 cast되어 catch되지 못한다. */
	#undef __DCL_HAVE_THROWS_SPEC
	#define __DCL_HAVE_THROWS_SPEC			0
#endif

#if __DCL_WINDOWS
	#ifdef _DLL
		#ifdef __DCL_CORE_EXPORTS
			#define DCLCAPI	__declspec(dllexport)
			#define DCLCVAR	__declspec(dllexport)
			#define __DCL_NET_EXPORTS
		#else
			#define DCLCAPI	__declspec(dllimport)
			#define DCLCVAR	__declspec(dllimport)

			#ifdef _MSC_VER
				#if defined(_DEBUG)
					#pragma comment(lib, "DCLCoredd.lib")
				#elif defined(__DCL_DEBUG)
					#pragma comment(lib, "DCLCored.lib")
				#else
					#pragma comment(lib, "DCLCore.lib")
				#endif
			#endif
		#endif

		#ifdef __DCL_EXT_EXPORTS
			#define DCLEAPI	__declspec(dllexport)
			#define DCLEVAR	__declspec(dllexport)
		#else
			#define DCLEAPI	__declspec(dllimport)
			#define DCLEVAR	__declspec(dllimport)
		#endif
	#else
		#define DCLCAPI
		#define DCLCVAR
		#define DCLEAPI
		#define DCLEVAR
	#endif

	#define DCL_DSO_EXPORT __declspec(dllexport)
#else
	#ifdef __DCL_CORE_EXPORTS
		#define DCLCAPI __attribute__ ((visibility("default")))
		#define DCLCVAR __attribute__ ((visibility("default")))
		#define __DCL_NET_EXPORTS
	#else
		#define DCLCAPI
		#define DCLCVAR
	#endif
	#ifdef __DCL_EXT_EXPORTS
		#define DCLEAPI __attribute__ ((visibility("default")))
		#define DCLEVAR __attribute__ ((visibility("default")))
	#else
		#define DCLEAPI
		#define DCLEVAR
	#endif

	#define DCL_DSO_EXPORT __attribute__ ((visibility("default")))
	#define __DCL_REENTRANT
#endif

/**********************************/

#ifdef __cplusplus
	/*****************************************************
		NAMESPACE CONFIG 
	*****************************************************/
	#if __DCL_HAVE_NAMESPACE
		#if __DCL_DEBUG
			namespace DCLd {}
			#define __DCL_NAMESPACE_STRING	L"DCLd::"
			#define __DCL_NAMESPACE			DCLd::
			#define __DCL_USING_NAMESPACE	using namespace DCLd;
			#define __DCL_BEGIN_NAMESPACE	namespace DCLd {
			#define __DCL_END_NAMESPACE		}
		#else
			namespace DCL { }		/* dummy declaration */
			#define __DCL_NAMESPACE_STRING	L"DCL::"
			#define __DCL_NAMESPACE			DCL::
			#define __DCL_USING_NAMESPACE	using namespace DCL;
			#define __DCL_BEGIN_NAMESPACE	namespace DCL {
			#define __DCL_END_NAMESPACE		}
		#endif
	#else
		#define __DCL_NAMESPACE_STRING
		#define __DCL_NAMESPACE
		#define __DCL_USING_NAMESPACE
		#define __DCL_BEGIN_NAMESPACE
		#define __DCL_END_NAMESPACE
	#endif

	/*****************************************************
		EXCEPTION SPECIFICATION CONFIG
	*****************************************************/
	#if __DCL_HAVE_THROWS_SPEC

		#define __DCL_THROWS0				throw()
		#define __DCL_THROWS1(e)			throw(e)
		#define __DCL_THROWS2(e1, e2)		throw(e1, e2)
		#define __DCL_THROWS3(e1, e2, e3)	throw(e1, e2, e3)

		/* MSVC C++ Exception Specification ignored	*/
		#ifdef _MSC_VER
			#pragma warning( disable : 4290 )
		#endif
	#else	/* __DCL_HAVE_THROWS_SPEC	*/
		#define __DCL_THROWS
		#define __DCL_THROWS1(e)
		#define __DCL_THROWS2(e1, e2)
		#define __DCL_THROWS3(e1, e2, e3)
	#endif
#else	/* __cplusplus	*/
	#define __DCL_THROWS
	#define __DCL_THROWS1(e)
	#define __DCL_THROWS2(e1, e2)
	#define __DCL_THROWS3(e1, e2, e3)
#endif	/* __cplusplus	*/


/*****************************************************
	BASIC TYPE DEFINITION
*****************************************************/
#ifdef __GNUC__
	#ifndef __STDC_VERSION__
		#define __STDC_VERSION__ 199901L
	#endif
#endif

/* need size_t, ssize_t */
#include <stddef.h>
#include <sys/types.h>

#ifdef _SSIZE_T_DEFINED
	/* MinGW */
	#define __ssize_t_defined
#endif

#ifndef __ssize_t_defined
	#ifdef __GNUC__
		typedef __ssize_t ssize_t;
	#elif defined(_WIN64)
		typedef __int64	ssize_t;
	#elif defined(_WIN32)
		typedef __int32	ssize_t;
	#endif
	#define __ssize_t_defined
#endif

#ifdef __GNUC__
	typedef int errno_t;
	#define __errno_t_defined
#endif
#ifdef _MSC_VER
	#if _MSC_VER <= 1200
		typedef int errno_t;
	#endif
	#define __errno_t_defined
#endif

/* Compiler predefined macro */
#ifndef __TIMESTAMP__
	#define __TIMESTAMP__	__DATE__ " " __TIME__
#endif

#if __DCL_WINDOWS && !defined(PATH_MAX)
	/* _MSC_VER 에서 _POSIX_가 !defined 이면 PATH_MAX가 포함되지 않는다. */
	#ifdef _MAX_PATH
		#define PATH_MAX		_MAX_PATH
	#elif defined(MAX_PATH)
		#define PATH_MAX		MAX_PATH
	#else
		#define PATH_MAX		1024
	#endif
#endif

#ifndef __WORDSIZE
	/* linux bits/wordsize.h */
	#if defined(_WIN64)
		#define __WORDSIZE	64
	#elif defined(_WIN32)
		#define __WORDSIZE	32
	#else
		#error "Unknown marchine wordsize!"
	#endif
#endif

#ifndef __BYTE_ORDER
	#define __LITTLE_ENDIAN		1234
	#define __BIG_ENDIAN		4321
	#if defined(_M_ALPHA) || defined(_M_IX86) || defined(_M_X64)
		#define __BYTE_ORDER	__LITTLE_ENDIAN
	#endif
	#ifdef _M_IA64
		#define __BYTE_ORDER	__BIG_ENDIAN
	#endif
#endif

#include <stdint.h>

#ifndef __SIZEOF_WCHAR_T__
	#if WCHAR_MAX == 0xffff
		// wchar_t	== unsigned short
		// wint_t	== unsigned int
		#define __SIZEOF_WCHAR_T__	2
	#else
		#define __SIZEOF_WCHAR_T__	4
	#endif
#endif

//#if __DCL_WINDOWS
//	typedef __int8				int8_t;
//	typedef __int16				int16_t;
//	typedef __int32				int32_t;
//	typedef __int64				int64_t;
//	typedef unsigned __int8		uint8_t;
//	typedef unsigned __int16	uint16_t;
//	typedef unsigned __int32	uint32_t;
//	typedef unsigned __int64	uint64_t;
//#endif

typedef unsigned char			byte_t;
typedef wchar_t					char_t;

/* limits */
#undef INT8_MIN
#undef INT16_MIN
#undef INT32_MIN
#undef INT64_MIN

#undef INT8_MAX
#undef INT16_MAX
#undef INT32_MAX
#undef INT64_MAX

#undef UINT8_MAX
#undef UINT16_MAX
#undef UINT32_MAX
#undef UINT64_MAX

#include <limits.h>

#ifdef _MSC_VER
	#define INT8_MIN		_I8_MIN
	#define INT16_MIN		_I16_MIN
	#define INT32_MIN		_I32_MIN
	#define INT64_MIN		_I64_MIN

	#define INT8_MAX		_I8_MAX
	#define INT16_MAX		_I16_MAX
	#define INT32_MAX		_I32_MAX
	#define INT64_MAX		_I64_MAX

	#define UINT8_MAX		_UI8_MAX
	#define UINT16_MAX		_UI16_MAX
	#define UINT32_MAX		_UI32_MAX
	#define UINT64_MAX		_UI64_MAX
#else	/* __GNUC__ */
	#define INT8_MIN		SCHAR_MIN
	#define INT16_MIN		SHRT_MIN
	#define INT32_MIN		INT_MIN
	#define INT64_MIN		LLONG_MIN

	#define INT8_MAX		SCHAR_MAX
	#define INT16_MAX		SHRT_MAX
	#define INT32_MAX		INT_MAX
	#define INT64_MAX		LLONG_MAX

	#define UINT8_MAX		UCHAR_MAX
	#define UINT16_MAX		USHRT_MAX
	#define UINT32_MAX		UINT_MAX
	#define UINT64_MAX		ULLONG_MAX
#endif

#ifdef __GNUC__
	#undef BOOL
	#undef TRUE
	#undef FALSE
	typedef int BOOL;
	#define FALSE 0
	#define TRUE !FALSE
#endif

#ifndef NULL
	#ifdef __cplusplus
		#define NULL 0
	#else
		#define NULL (void*)0
	#endif
#endif

/*****************************************************
	COMMENTS DEFINATIONS
*****************************************************/

#undef _CONST
#undef _PRIVATE
#undef __PROTECTED
#undef _PUBLIC

#define _CONST
#define _PRIVATE		public
#define __PROTECTED		public
#define _PUBLIC
#define __protected		public

/* close() 에서 참조된 객체를 close하지 않는다 */
#define __noclose__

/* close() 에서 포인터로 넘겨받은 객체를 close하고 destroy 한다 */
#define __destroy__

#define __countof(array, type)	(sizeof(array) / sizeof(type))

/*****************************************************
	DCL VERSION INFORMATION
*****************************************************/

#define DCL_MAKE_VERSION(uMajor, uMinor)	((uint32_t)((uMajor << 16) | uMinor))
#define DCL_MAJOR_VERSION(uVersion)			((unsigned int)(uVersion >> 16))
#define DCL_MINOR_VERSION(uVersion)			((unsigned int)(uVersion & 0x0000ffff))

/* DCL Library Version			*/
#define DCL_VERSION							DCL_MAKE_VERSION(4, 1)
#define DCL_CORE_VERSION					DCL_MAKE_VERSION(4, 1)
#define DCL_EXT_VERSION						DCL_MAKE_VERSION(1, 0)

/* DCL SQL Interface Version	*/
#define DCL_SQL_VERSION						DCL_MAKE_VERSION(3, 3)

/* DCL Http Server Environment/Extension Version */
#define DCL_HTTP_SERVER_VERSION				DCL_MAKE_VERSION(3, 2)

/* uModuleType					*/
#define DCL_CORE_LIB						1
#define DCL_NET_LIB							2
#define DCL_EXT_LIB							3
#define DCL_SQL_DRIVER_MODULE				11
#define DCL_HTTP_SERVLET_MODULE				21

#define DCL_DSO_ENTRY_POINT					DCLDSOEntryPoint
#define DCL_DSO_ENTRY_POINT_STRING			"DCLDSOEntryPoint"

#if __DCL_DEBUG
	#define DCL_BUILD_FLAG	1
#else
	#define DCL_BUILD_FLAG	0
#endif

/*
	DCL DSO Module Entry Example

typedef struct
{
	// DCL common members
	uint32_t	uSize;					// size of this structure
	uint32_t	uDCLVersion;			// DCL_VERSION	
	uint32_t	uBuldFlag;				// release(0), debug(1)
	uint32_t	uModuleType;			//
	const wchar_t*	pszDescription;		// module description

	// application private members
	uint32_t	uVersion;				// module application version
		...
} MODULE_SPEC

extern "C" {
DCL_DSO_EXPORT
MODULE_SPEC DCL_DSO_ENTRY_POINT =
{
	sizeof(MODULE_SPEC),
	DCL_VERSION,
	DCL_BUILD_FLAG,
	DCL_SQL_DRIVER_MODULE,		// if module is database driver
	L"simple description",
	DCL_SQL_VERSION,
	...
};
}

*/

typedef struct __DCL_LIBRARY_MODULE 
{
	uint32_t		uSize;				/* size of this structure	*/
	uint32_t		uDCLVersion;		/* DCL_VERSION				*/
	const char*		pszBuildTimeStamp;	/* __TIMESTAMP__			*/
	uint32_t		uBuldFlag;			/* release(0), debug(1)		*/
	uint32_t		uModuleType;		/* DCL_CORE_LIB, ...		*/
	const char*		pszDescription;		/* module description		*/

} DCL_LIBRARY_MODULE;

#define DCL_WIN_REG_BASE	L"Software\\Daejung Kim\\DCL"

#endif		/* __DCL_CONFIG_H__ */
