#ifndef __DCL_DATE_TIME_H__
#error "Never use <dcl/core/DateTime.inl> directly; include <dcl/core/DateTime.h>"
#endif

#ifndef __DCL_DATE_TIME_INL__
#define __DCL_DATE_TIME_INL__

/*
#if __DCL_DEBUG
static const char* __pszDateTime_inl__ = "dcl/DateTime.inl";
#undef __THIS_FILE__
#define __THIS_FILE__ __pszDateTime_inl__
#endif
*/

//////////////// Date ////////////////

DCLCAPI inline Date operator + (long _days, const Date& _date)
{
	return operator + (_date, _days);
}	

DCLCAPI inline Date operator - (const Date& _date, long _days)
{
	return operator + (_date, -_days);
}

DCLCAPI inline long operator - (const Date& _date1, const Date& _date2)
{
	return _date1.days() - _date2.days();
}

DCLCAPI inline bool operator == (const Date& _date1, const Date& _date2)
{
	return _date1.days() == _date2.days();
}

DCLCAPI inline bool operator != (const Date& _date1, const Date& _date2)
{
	return _date1.days() != _date2.days();
}

DCLCAPI inline bool operator >= (const Date& _date1, const Date& _date2)
{
	return _date1.days() >= _date2.days();
}

DCLCAPI inline bool operator <= (const Date& _date1, const Date& _date2)
{
	return _date1.days() <= _date2.days();
}

DCLCAPI inline bool operator > (const Date& _date1, const Date& _date2)
{
	return _date1.days() > _date2.days();
}

DCLCAPI inline bool operator < (const Date& _date1, const Date& _date2)
{
	return _date1.days() < _date2.days();
}

//////////////// Time ////////////////

inline long Time::totalMilliSeconds() const
{
	return __milliseconds;
}

DCLCAPI inline Time operator + (long _milliseconds, const Time& _time)
{
	return operator + (_time, _milliseconds);
}	

DCLCAPI inline Time operator - (const Time& _time, long _milliseconds)
{
	return operator + (_time, -_milliseconds);
}

DCLCAPI inline long operator - (const Time& _time1, const Time& _time2)
{
	return _time1.totalMilliSeconds() - _time2.totalMilliSeconds();
}

DCLCAPI inline bool operator == (const Time& _time1, const Time& _time2)
{
	return _time1.totalMilliSeconds() == _time2.totalMilliSeconds();
}

DCLCAPI inline bool operator != (const Time& _time1, const Time& _time2)
{
	return _time1.totalMilliSeconds() != _time2.totalMilliSeconds();
}

DCLCAPI inline bool operator >= (const Time& _time1, const Time& _time2)
{
	return _time1.totalMilliSeconds() >= _time2.totalMilliSeconds();
}

DCLCAPI inline bool operator <= (const Time& _time1, const Time& _time2)
{
	return _time1.totalMilliSeconds() <= _time2.totalMilliSeconds();
}

DCLCAPI inline bool operator > (const Time& _time1, const Time& _time2)
{
	return _time1.totalMilliSeconds() > _time2.totalMilliSeconds();
}

DCLCAPI inline bool operator < (const Time& _time1, const Time& _time2)
{
	return _time1.totalMilliSeconds() < _time2.totalMilliSeconds();
}

//////////////// Interval ////////////////
inline int64_t Interval::totalMilliSeconds() const
{
	return __milliseconds;
}

DCLCAPI inline bool operator == (const Interval& _iv1, const Interval& _iv2)
{
	return _iv1.totalMilliSeconds() == _iv2.totalMilliSeconds();
}

DCLCAPI inline bool operator != (const Interval& _iv1, const Interval& _iv2)
{
	return _iv1.totalMilliSeconds() != _iv2.totalMilliSeconds();
}

DCLCAPI inline bool operator >= (const Interval& _iv1, const Interval& _iv2)
{
	return _iv1.totalMilliSeconds() >= _iv2.totalMilliSeconds();
}

DCLCAPI inline bool operator <= (const Interval& _iv1, const Interval& _iv2)
{
	return _iv1.totalMilliSeconds() <= _iv2.totalMilliSeconds();
}

DCLCAPI inline bool operator > (const Interval& _iv1, const Interval& _iv2)
{
	return _iv1.totalMilliSeconds() > _iv2.totalMilliSeconds();
}

DCLCAPI inline bool operator < (const Interval& _iv1, const Interval& _iv2)
{
	return _iv1.totalMilliSeconds() < _iv2.totalMilliSeconds();
}

//////////////// DateTime ////////////////
inline Date& DateTime::date()
{
	return __date;
}

inline const Date& DateTime::date() const
{
	return __date;
}

inline Time& DateTime::time()
{
	return __time;
}

inline const Time& DateTime::time() const
{
	return __time;
}

DCLCAPI inline bool operator == (const DateTime& _dt1, const DateTime& _dt2)
{
	return DateTime::compare(_dt1, _dt2) == 0;
}

DCLCAPI inline bool operator != (const DateTime& _dt1, const DateTime& _dt2)
{
	return DateTime::compare(_dt1, _dt2) != 0;
}

DCLCAPI inline bool operator >= (const DateTime& _dt1, const DateTime& _dt2)
{
	return DateTime::compare(_dt1, _dt2) >= 0;
}

DCLCAPI inline bool operator <= (const DateTime& _dt1, const DateTime& _dt2)
{
	return DateTime::compare(_dt1, _dt2) <= 0;
}

DCLCAPI inline bool operator > (const DateTime& _dt1, const DateTime& _dt2)
{
	return DateTime::compare(_dt1, _dt2) > 0;
}

DCLCAPI inline bool operator < (const DateTime& _dt1, const DateTime& _dt2)
{
	return DateTime::compare(_dt1, _dt2) < 0;
}

/*
#if __DCL_DEBUG
#undef __THIS_FILE__
#define __THIS_FILE__ __T(__FILE__)
#endif
*/

#endif	// __DCL_DATE_TIME_INL__
