#ifndef __DCL_DLL_H__
#define __DCL_DLL_H__			20041127

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif

__DCL_BEGIN_NAMESPACE

class DCLCAPI DllException : public SysError
{
	DECLARE_CLASSINFO(DllException)
public:
	String	__message;

public:
	DllException(const String& _name, Exception* _cause);
	DllException(const String& _name, uint32_t _errorNo);
	DllException(const String& _name, const String& _message);

	virtual String toString() const;
};


class DCLCAPI Dll : public Object
{
	DECLARE_CLASSINFO(Dll)

public:
	Dll();
	virtual ~Dll();

	enum OpenFlag
	{
		DEFAULT = 0
	};

	void open(
		const String& _filename, int _flags = DEFAULT
		) __DCL_THROWS1(DllException*);

	void close() 
		__DCL_THROWS1(DllException*);

	void* getAddress(const char* _symbol)
		__DCL_THROWS1(DllException*);

	void* getAddress(const String& _symbol)
		__DCL_THROWS1(DllException*);

	const String& fileName() const { return __filename; }

protected:
	void*	__handle;
	String	__filename;
};

__DCL_END_NAMESPACE

#endif	// __DCL_DLL_H__

