#ifndef __DCL_FILE_INPUT_STREAM_H__
#define __DCL_FILE_INPUT_STREAM_H__	20071009

#ifndef __DCL_INPUT_STREAM_H__
#include <dcl/InputStream.h>
#endif
#ifndef __DCL_FILE_H__
#include <dcl/File.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * 파일로부터 바이트 스트림을 읽는다.
 * 파일이 블록 장치이면 블록의 크기 단위로 입력 버퍼가 설정된다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 1.0
 *
 * @see		File
 */
class DCLCAPI FileInputStream : public InputStream
{
	DECLARE_CLASSINFO(FileInputStream)
public:
	/**
	 * 파일이름 등의 간략한 요약을 리턴한다.
	 */
	virtual String toString() const;

	/**
	 * 객체를 구성한다. 파일은 File::READONLY로 열린다.
	 *
	 * @param _path
	 *		파일이름을 포함한 경로
	 */
	FileInputStream(const String& _path)
			__DCL_THROWS1(IOException*);

#ifdef _MSC_VER
	FileInputStream(const wchar_t* _path)
			__DCL_THROWS1(IOException*);
#endif

	/**
	 * 열려진 파일로 객체를 구성한다.
	 * _file은 {@link #close()}에서 close하지 않으며, 생명주기동안 유효해야 한다.
	 */
	FileInputStream(File& __noclose__ _file)
			__DCL_THROWS1(IOException*);

	/**
	 * 열려진 파일핸들로 객체를 구성한다.
	 * _handle은 {@link #close()}에서 닫지 않는다.
	 */
	FileInputStream(File::HandleType __noclose__ _handle)
			__DCL_THROWS1(IOException*);

	/**
	 * 이미 열린 파일은 닫고, 파일을 새로 연다. 
	 */
	void open(const String& _path)
			__DCL_THROWS1(IOException*);

	/**
	 * 객체의 파괴를 수행한다.
	 * close하지 않았으면 {@link #close()}하며 예외가 발생하면 무시한다.
	 */
	virtual ~FileInputStream();

	/**
	 * 버퍼를 지우고 파일을 닫는다.
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 * Non-Block으로 읽혀질 수 있는 바이트 수를 리턴한다.
	 * 파일의 크기가 size_t의 범위보다 크면 (size_t)-1을 리턴한다.
	 */
	virtual size_t available()
			__DCL_THROWS1(IOException*);
#if 0
	virtual size_t peek(void* p, size_t n)
			__DCL_THROWS1(IOException*);
#endif
	/*
	 * 스트림으로부터 데이터를 읽는다.
	 * @param _buf
	 *			버퍼
	 * @param _n
	 *			버퍼의 크기가 _n바이트
	 * @return
	 *			읽은 바이트의 수이다. 0이면 EOF이다.
	 */
	virtual size_t read(void* _buf, size_t _n) 
			__DCL_THROWS1(IOException*);

protected:
	File*		__file;
	bool		__closeDestroy;

	byte_t*		__buf;
	size_t		__bufSize;
	const byte_t*	__cacheStart;
	size_t		__cacheSize;

	void init(File* _pFile);
			__DCL_THROWS1(IOException*);
};

__DCL_END_NAMESPACE

#endif	// __DCL_FILE_INPUT_STREAM_H__

