#ifndef __DCL_FILE_OUTPUT_STREAM_H__
#define __DCL_FILE_OUTPUT_STREAM_H__	20071009

#ifndef __DCL_OUTPUT_STREAM_H__
#include <dcl/OutputStream.h>
#endif
#ifndef __DCL_FILE_H__
#include <dcl/File.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * 파일에 바이트 스트림을 출력한다.
 * UNIX 운영체제에서 파일이 블록 장치이면 블록의 크기 단위로 버퍼링을 하여 출력하고,
 * 그 외에는 4096바이트 단위로 버퍼링을 한다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 1.0
 *
 * @see		File
 */
class DCLCAPI FileOutputStream : public OutputStream
{
	DECLARE_CLASSINFO(FileOutputStream)
public:
	/**
	 * 파일이름 등의 간략한 요약을 리턴한다.
	 */
	virtual String toString() const;

	/**
	 * 객체를 구성한다.
	 *
	 * @param _path
	 *		파일이름을 포함한 경로
	 * @param _truncate
	 *		기존에 파일이 존재하는 경우 true이면,
	 *		File::TRUNCATE 플래그가 사용되어 파일의 크기를 0바이트로 설정하고,
	 *		false이면 File::APPEND 플래그가 사용되어 추가모드로 열린다.
	 */
	FileOutputStream(const String& _path, bool _truncate)
			__DCL_THROWS1(IOException*);

	/**
	 * 열려진 파일로 객체를 구성한다.
	 * _file은 {@link #close()}에서 close하지 않으며, 생명주기동안 유효해야 한다.
	 */
	FileOutputStream(File& __noclose__ _file)
			__DCL_THROWS1(IOException*);

	/**
	 * 열려진 파일핸들로 객체를 구성한다.
	 * _handle은 {@link #close()}에서 닫지 않는다.
	 */
	FileOutputStream(File::HandleType __noclose__ _handle)
			__DCL_THROWS1(IOException*);

	/**
	 * 열려진 파일로 객체를 구성한다.
	 * _pFile은 {@link #close()}에서 close되고, 파괴된다.
	 */
	FileOutputStream(File* __destroy__ _pFile)
			__DCL_THROWS1(IOException*);

	/**
	 * 이미 열린 파일은 닫고, 파일을 새로 연다. 
	 */
	void open(const String& _path, bool _truncate = true)
			__DCL_THROWS1(IOException*);

	/**
	 * 객체의 파괴를 수행한다.
	 * close하지 않았으면 {@link #close()}하며 예외가 발생하면 무시한다.
	 */
	virtual ~FileOutputStream();

	/**
	 * 버퍼를 지우고 파일을 닫는다.
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);
	/**
	 * 버퍼에 데이터가 있으면 비운다
	*/
	virtual void flush()
			__DCL_THROWS1(IOException*);

	/**
	 * _n 바이트 데이터를 출력한다.
	 */
	virtual OutputStream& write(const void* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

protected:
	/**
	 * 블록장치 여부를 확인하고, 출력버퍼의 크기를 설정한다.
	 */
	void init(File* _pFile)
			__DCL_THROWS1(IOException*);

protected:
	File*		__file;
	bool		__closeDestroy;

	byte_t*	__buf;
	size_t	__bufSize;
	size_t	__dataSize;
};

__DCL_END_NAMESPACE

#endif	// __DCL_FILE_OUTPUT_STREAM_H__

