#ifndef __DCL_FILE_READER_H__
#define __DCL_FILE_READER_H__		20110205

#ifndef __DCL_FILE_INPUT_STREAM_H__
#include <dcl/FileInputStream.h>
#endif
#ifndef __DCL_INPUT_STREAM_READER_H__
#include <dcl/InputStreamReader.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * 텍스트 파일을 읽는다. 이것은 InputStreamReader와 FileInputStream을 조합한다.
 *
 * @author	Daejung Kim
 * @since	DCL Version 3.0
 *
 * @see		InputStreamReader
 * @see		FileInputStream
 * @see		CharsetDecoder
 */
class DCLCAPI FileReader : public InputStreamReader
{
	DECLARE_CLASSINFO(FileReader)
public:
	/**
	 * 주어진 경로의 파일을 읽는 객체를 구성한다.
	 * @param _path
	 *		파일이름을 포함한 경로
	 * @param _pDecoder
	 *		NULL이면 처음 읽는 2~4바이트를 사용하여 BOM을 검사 한 후, 확인이 안되면 LocaleEncoder를 사용한다.
	 */
	FileReader(
			const String& _path,
			CharsetDecoder* __destroy__ _pDecoder = NULL
		) __DCL_THROWS1(IOException*)
		: InputStreamReader(new FileInputStream(_path), _pDecoder)
	{
	}

	/**
	 * 열려진 파일로 객체를 구성한다.
	 * @param _file
	 *		_file은 {@link #close()}에서 close하지 않으며, 객체의 생명주기동안 유효해야 한다.
	 * @param _pDecoder
	 *		NULL이면 처음 읽는 2~4바이트를 사용하여 BOM을 검사 한 후, 확인이 안되면 LocaleEncoder를 사용한다.
	 */
	FileReader(
			File& __noclose__ _file,
			CharsetDecoder* __destroy__ _pDecoder = NULL
		) __DCL_THROWS1(IOException*)
		: InputStreamReader(new FileInputStream(_file), _pDecoder)
	{
	}

	/**
	 * 열려진 파일핸들로 객체를 구성한다.
	 * @param _handle
	 *		_handle은 {@link #close()}에서 닫지 않는다.
	 * @param _pDecoder
	 *		NULL이면 처음 읽는 2~4바이트를 사용하여 BOM을 검사 한 후, 확인이 안되면 LocaleEncoder를 사용한다.
	 */
	FileReader(
			File::HandleType __noclose__ _handle,
			CharsetDecoder* __destroy__ _pDecoder = NULL
		) __DCL_THROWS1(IOException*)
		:  InputStreamReader(new FileInputStream(_handle), _pDecoder)
	{
	}
};

__DCL_END_NAMESPACE

#endif		// __DCL_FILE_READER_H__
