#ifndef __DCL_FILE_WRITER_H__
#define __DCL_FILE_WRITER_H__		20110205

#ifndef __DCL_FILE_OUTPUT_STREAM_H__
#include <dcl/FileOutputStream.h>
#endif
#ifndef __DCL_OUTPUT_STREAM_WRITER_H__
#include <dcl/OutputStreamWriter.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * wchar_t 텍스트 파일을 작성한다. 이것은 OutputStreamWriter와 FileOutputStream을 조합한다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		OutputStreamWriter
 * @see		FileOutputStream
 * @see		CharsetEncoder
 */
class DCLCAPI FileWriter : public OutputStreamWriter
{
	DECLARE_CLASSINFO(FileWriter)
public:
	/**
	 * 주어진 경로로 파일을 작성하는 객체를 구성한다.
	 * @param _path
	 *		파일이름을 포함한 경로
	 * @param _truncate
	 *		기존에 파일이 존재하는 경우 true이면,
	 *		File::TRUNCATE 플래그가 사용되어 파일의 크기를 0바이트로 설정하고,
	 *		false이면 File::APPEND 플래그가 사용되어 추가모드로 열린다.
	 * @param _pEncoder 
	 *		NULL이면 LocaleEncoder가 사용된다.
	 */
	FileWriter(const String& _path, bool _truncate, CharsetEncoder* _pEncoder = NULL)
			__DCL_THROWS1(IOException*);

	/**
	 * 열려진 파일로 객체를 구성한다.
	 * _file은 {@link #close()}에서 close하지 않으며, 객체의 생명주기동안 유효해야 한다.
	 * @param _pEncoder 
	 *		NULL이면 LocaleEncoder가 사용된다.
	 */
	FileWriter(File& __noclose__ _file, CharsetEncoder* _pEncoder = NULL)
			__DCL_THROWS1(IOException*);

	/**
	 * 열려진 파일핸들로 객체를 구성한다.
	 * _handle은 {@link #close()}에서 닫지 않는다.
	 * @param _pEncoder 
	 *		NULL이면 LocaleEncoder가 사용된다.
	 */
	FileWriter(File::HandleType __noclose__ _handle, CharsetEncoder* _pEncoder = NULL)
			__DCL_THROWS1(IOException*);
};

#if !__DCL_DEBUG
inline FileWriter::FileWriter(const String& _path, bool _truncate, CharsetEncoder* _pEncoder)
		__DCL_THROWS1(IOException*)
		: OutputStreamWriter(new FileOutputStream(_path, _truncate), _pEncoder)
{
}

inline FileWriter::FileWriter(File& __noclose__ _file, CharsetEncoder* _pEncoder)
		__DCL_THROWS1(IOException*)
		: OutputStreamWriter(new FileOutputStream(_file), _pEncoder)
{
}

inline FileWriter::FileWriter(File::HandleType __noclose__ _handle, CharsetEncoder* _pEncoder)
		__DCL_THROWS1(IOException*)
		:  OutputStreamWriter(new FileOutputStream(_handle), _pEncoder)
{
}

#endif

__DCL_END_NAMESPACE

#endif		// __DCL_FILE_WRITER_H__
