#ifndef __DCL_HASH_FUN_H__
#define __DCL_HASH_FUN_H__		20110303

#if !__DCL_WINDOWS
#include <bits/types/wint_t.h>
#endif

#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

__DCL_BEGIN_NAMESPACE

template<typename TYPE>
struct HashFun
{
};

inline unsigned int __wide_string_hashKey(const wchar_t* _psz)
{
	unsigned int h = 0;
	for( ; *_psz; _psz++)
	{
		h = 5 * h + (wint_t) *_psz;
	}
	return h;
}

template<>
struct HashFun<String>
{
	unsigned int hashKey(const String& _str) const
	{
		return __wide_string_hashKey(_str.data());
	}
};

template<>
struct HashFun<const wchar_t*>
{
	unsigned int hashKey(const wchar_t* _psz) const
	{
		return __wide_string_hashKey(_psz);
	}
};

template<>
struct HashFun<wchar_t*>
{
	unsigned int hashKey(const wchar_t* _psz) const
	{
		return __wide_string_hashKey(_psz);
	}
};

inline unsigned int __byte_string_hashKey(const char* _psz)
{
	unsigned int h = 0;
	for( ; *_psz; _psz++)
	{
		h = 5 * h + (unsigned char) *_psz;
	}
	return h;
}

template<>
struct HashFun<ByteString>
{
	unsigned int hashKey(const ByteString& _str) const
	{
		return __byte_string_hashKey(_str.data());
	}
};

template<>
struct HashFun<const char*>
{
	unsigned int hashKey(const char* _psz) const
	{
		return __byte_string_hashKey(_psz);
	}
};

template<>
struct HashFun<char*>
{
	unsigned int hashKey(const char* _psz) const
	{
		return __byte_string_hashKey(_psz);
	}
};

template<>
struct HashFun<char>
{
	unsigned int hashKey(char _c) const
	{
		return _c;
	}
};

template<>
struct HashFun<unsigned char>
{
	unsigned int hashKey(unsigned char _c) const
	{
		return _c;
	}
};

template<>
struct HashFun<short>
{
	unsigned int hashKey(short _n) const
	{
		return _n;
	}
};

template<>
struct HashFun<unsigned short>
{
	unsigned int hashKey(unsigned short _n) const
	{
		return _n;
	}
};

template<>
struct HashFun<int>
{
	unsigned int hashKey(int _n) const
	{
		return _n;
	}
};

template<>
struct HashFun<unsigned int>
{
	unsigned int hashKey(unsigned int _n) const
	{
		return _n;
	}
};

template<>
struct HashFun<long>
{
	unsigned int hashKey(long _n) const
	{
		return _n;
	}
};

template<>
struct HashFun<unsigned long>
{
	unsigned int hashKey(unsigned long _n) const
	{
		return _n;
	}
};

template<>
struct HashFun<long long>
{
	unsigned int hashKey(long long _n) const
	{
		return (unsigned int) _n;
	}
};

template<>
struct HashFun<unsigned long long>
{
	unsigned int hashKey(unsigned long long _n) const
	{
		return (unsigned int) _n;
	}
};

template<>
struct HashFun<void *>
{
	unsigned int hashKey(void* _p) const
	{
		return (unsigned int) (size_t) _p;
	}
};

template<>
struct HashFun<const void *>
{
	unsigned int hashKey(const void* _p) const
	{
		return (unsigned int) (size_t) _p;
	}
};

DCLCAPI size_t DCLGetNextPrimNumber(size_t _n);

__DCL_END_NAMESPACE

#endif		// __DCL_HASH_FUN_H__
