
#ifndef __DCL_HTML_ENTITY_H__
#define	__DCL_HTML_ENTITY_H__	20050530_20060103

// XHTML Entity Sets
// http://www.w3.org/TR/xhtml1/dtds.html#h-A2

__DCL_BEGIN_NAMESPACE

class DCLCAPI Html
{
public:

	// '<' ==> &lt;		&#60;
	// '>' ==> &gt;		&#62;
	// '&' ==> &amp;	&#38;
	// '"' ==> &quot;	&#34;
	// ''' ==> &apos;	&#39;
	static String escape(
			const String&	_str,
			const wchar_t* 	_chars		// " <>"'&, NULL is all
			);

	static String strip(
			const String& _str,
			const wchar_t* _elementNames	// NULL(all) or ',' delimiter ex: "html,head,meta,!"
			);

	static String format(
			const String& 	_str,
			int				_tab2Space,
			const String& 	_beginOfLine,
			const String& 	_endOfLine
			);

};

__DCL_END_NAMESPACE

#endif	// __DCL_HTML_ENTITY_H__
