#ifndef __DCL_HTTP_HEADER_H__
#define __DCL_HTTP_HEADER_H__		20050509

#ifndef __DCL_INCLUDED_TIME_H
#include <dcl/_time.h>
#endif

#ifndef __DCL_STRING_H__
	#include <dcl/String.h>
#endif

#ifdef __DCL_DEBUG
static const char_t* __pszHttpHeader_h__ = __T("dcl/HttpHeader.h");
#undef __THIS_FILE__
#define __THIS_FILE__ __pszHttpHeader_h__
#endif

__DCL_BEGIN_NAMESPACE

class DCLCAPI HttpHeader 
{
protected:
	String __name;
	String __content;
public:
	HttpHeader();
	HttpHeader(const HttpHeader& src);
	HttpHeader(const wchar_t* _name, const wchar_t* _content = NULL);
	const String& name() const;
	const String& content() const;
	String toString() const;
};

class DCLCAPI HttpSetCookie : public HttpHeader
{
public:
	// http://www.faqs.org/rfcs/rfc2109.html
#ifdef RFC2109
	HttpSetCookie(const wchar_t* _name,
			const wchar_t* _value = NULL,
			const wchar_t* _comment = NULL,
			const wchar_t* _domain = NULL,
			int _maxAge = 0,		// 초 단위
			const wchar_t* _path = NULL,
			bool _secure = false,
			int nVersion = 0
			);
#endif	// RFC2109
	// php style
	HttpSetCookie(const wchar_t* _name,
			const wchar_t* _value = NULL,
			time_t _expires = 0,
			const wchar_t* _path = NULL,
			const wchar_t* _domain = NULL,
			bool _secure = false
			);
};

// http://www.faqs.org/rfcs/rfc2965.html
class DCLCAPI HttpSetCookie2 : public HttpHeader
{

};

class DCLCAPI HttpExpires : public HttpHeader
{
public:
	HttpExpires(time_t _expires);
};

inline HttpHeader::HttpHeader()
{
}

inline HttpHeader::HttpHeader(const HttpHeader& src)
{
	__name = src.__name;
	__content = src.__content;
}

inline HttpHeader::HttpHeader(const wchar_t* _name, const wchar_t* _content /* = NULL */)
{
	__DCL_ASSERT(_name != NULL);
	__DCL_ASSERT(*_name != L'\0');

	__name = _name;
	
	if (_content != NULL)
		__content = _content;
}

inline const String& HttpHeader::name() const
{
	return __name;
}

inline const String& HttpHeader::content() const
{
	return __content;
}

inline bool operator == (const HttpHeader& x, const HttpHeader& y)
{
	return (x.name() == y.name()) && (x.content() == y.content());
}

__DCL_END_NAMESPACE

#ifdef __DCL_DEBUG
#undef __THIS_FILE__
#define __THIS_FILE__	__T(__FILE__)
#endif

#endif	// __DCL_HTTP_HEADER_H__
