#ifndef __DCL_HTTP_SERVLET_H__
#define __DCL_HTTP_SERVLET_H__		20050530

// HTTP Server -let
#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif

#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif
// #ifndef __DCL_COLLECTION_H__
// #include <dcl/core/Collection.h>
// #endif

#ifndef __DCL_HTTP_SERVER_EXTENSION_H__
#include <dcl/HttpServerExtension.h>
#endif
#ifndef __DCL_HTTP_HEADER_H__
#include <dcl/HttpHeader.h>
#endif

__DCL_BEGIN_NAMESPACE

/*
Object
	HttpServletContext;
		HttpServletContextEx;
	HttpServlet;
		HttpServletEx;
*/

class DCLCAPI HttpServletContext : public Object
{
	DECLARE_CLASSINFO(HttpServletContext)
public :
	HttpServletContext(
		const DCL_HTTP_SERVER_API* _SAPI,
		const DCL_HTTP_SERVLET_CONTEXT* _context
		);
	virtual ~HttpServletContext();

	// request
	String remoteAddr() const;
	unsigned int remotePort() const;
	String method() const;
	unsigned int methodNo() const;
	String path() const;
	String queryString() const;
	String contentType() const;
	size_t contentLength() const;
	String scriptFilename() const;
	String scriptData() const;

	const String& resContentType() const;

	ByteString getHttpHeader(const char* _name = NULL) const;
	ByteString getCgiVariable(const char* _name = NULL) const;
	String getHttpHeader(const wchar_t* _name = NULL) const;
	String getCgiVariable(const wchar_t* _name = NULL) const;

	size_t read(void* pv, size_t n)	__DCL_THROWS1(IOException*);

	// response
	void setStatusCode(unsigned int uHttpStatusCode);
	void setContentType(const wchar_t* _contentType, const wchar_t* pszCharset = NULL);
	void addHeader(const HttpHeader& httpHeader);
	void flushHeader();

	void write(const void* pv, size_t n) __DCL_THROWS1(IOException*);

protected:
	const DCL_HTTP_SERVER_API*		__SAPI;
	const DCL_HTTP_SERVLET_CONTEXT*	__context;

	String				__contentType;	// response Content-Type
	unsigned int		__statusCode;
	StringBuilder		__responseHeaders;
	bool				__headerFlushed;
};

class DCLCAPI HttpServlet : public Object
{
	DECLARE_CLASSINFO(HttpServlet)
public:
	HttpServlet();
	String getIniFileName(const wchar_t* _basename = NULL) const;

protected:
	// implement
	virtual void onInitialize()
					__DCL_THROWS1(Exception*);
	virtual void onCleanup()
					__DCL_THROWS1(Exception*);
	virtual void onHttpService(
					const DCL_HTTP_SERVLET_CONTEXT* pContext
					) = 0 __DCL_THROWS1(Exception*);

protected:
	const wchar_t*				__moduleName;
	const wchar_t*				__configPath;
	const wchar_t*				__tempPath;
	const DCL_HTTP_SERVER_API*	__SAPI;

public:
	// internal function
	static bool __initialize(
					HttpServlet* _servlet,
					const DCL_HTTP_SERVLET_CONFIG* _config,
					void* hErrorReport
					);

	static bool __cleanup(
					HttpServlet* _servlet,
					void* hErrorReport
					);

	static bool __httpService(
					HttpServlet* _servlet,
					const DCL_HTTP_SERVLET_CONTEXT* _context,
					void* hErrorReport
					);
};

#define HTTP_SERVLET_INSTANCE(ServletClass, Description) \
static HttpServlet*	__servlet__ = NULL; \
static BOOL ModuleInitialize( \
			const DCL_HTTP_SERVLET_CONFIG* pConfig, \
			void* hErrorReport \
			) \
{ \
	__servlet__ = new ServletClass; \
	if (!__servlet__) { \
		pConfig->pSAPI->pfnReportError( \
				hErrorReport, \
				L"Out of Memory", \
				13); \
		return FALSE; \
	} \
	else { \
		if (!HttpServlet::__initialize( \
				__servlet__, \
				pConfig, \
				hErrorReport \
				) \
			) { \
			delete __servlet__; \
			__servlet__ = NULL; \
			return FALSE; \
		} \
	} \
	return TRUE; \
} \
\
static BOOL ModuleCleanup( \
			void* hErrorReport \
			) \
{ \
	BOOL bResult = HttpServlet::__cleanup( \
					__servlet__, \
					hErrorReport \
					); \
	delete __servlet__; \
	__servlet__ = NULL; \
	return bResult; \
} \
\
static BOOL ModuleHttpService( \
			const DCL_HTTP_SERVLET_CONTEXT* pContext, \
			void* hErrorReport \
			) \
{ \
	return HttpServlet::__httpService( \
				__servlet__, \
				pContext, \
				hErrorReport \
				); \
}\
\
extern "C" { \
DCL_DSO_EXPORT \
DCL_HTTP_SERVLET DCL_DSO_ENTRY_POINT = { \
	sizeof(DCL_HTTP_SERVLET), \
	DCL_VERSION, \
	__T(__TIMESTAMP__), \
	DCL_BUILD_FLAG, \
	DCL_HTTP_SERVLET_MODULE, \
	Description, \
	DCL_HTTP_SERVER_VERSION, \
	ModuleInitialize, \
	ModuleCleanup, \
	ModuleHttpService \
}; \
} \

__DCL_END_NAMESPACE

#endif	// __DCL_HTTP_SERVLET_H__
