#ifndef __DCL_HTTP_SERVLET_EX_H__
#define __DCL_HTTP_SERVLET_EX_H__	20050530


#ifndef __DCL_HTTP_SERVLET_H__
#include <dcl/HttpServlet.h>
#endif
#ifndef __DCL_HTTP_COLLECTION_H__
#include <dcl/HttpCollection.h>
#endif
#ifndef __DCL_LISTED_HASH_MAP_H__
#include <dcl/ListedHashMap.h>
#endif
#ifndef __DCL_STRING_WRITER_H__
#include <dcl/StringWriter.h>
#endif

__DCL_BEGIN_NAMESPACE

class HttpServletEx;

class DCLCAPI HttpServletContextEx : public HttpServletContext
{
	DECLARE_CLASSINFO(HttpServletContextEx)
public:
	ListedStringToStringMap			__cookieMap;
	ListedStringToStringArrayMap	__queryMap;
	ListedStringToStringArrayMap	__formMap;
	StoredHttpFormData				__formFileMap;

public:
	StringWriter& writer();

protected:
	HttpServletContextEx(
		const DCL_HTTP_SERVER_API* _SAPI,
		const DCL_HTTP_SERVLET_CONTEXT* _context,
		const String& _tempPath
		);
	virtual ~HttpServletContextEx();

	void initRequest(size_t nMaxContentLength) __DCL_THROWS1(FormDataException*);

	StringWriter __responseBuf;

	friend class HttpServletEx;
};

class DCLCAPI HttpServletEx : public HttpServlet
{
	DECLARE_CLASSINFO(HttpServlet)
public:
	HttpServletEx();

protected:
	size_t	m_nMaxContentLength;

#ifdef __DCL_DEBUG
	// Content-Type이 text/* 일 경우 __DCL_TRACE의 내용을 추가
	bool	m_bEnableDebugOut;
#endif

protected:
	virtual void onInitialize()
					__DCL_THROWS1(Exception*);

	virtual void onService(
					HttpServletContextEx& ctx
					) = 0 __DCL_THROWS1(Exception*);

private:
	virtual void onHttpService(
					const DCL_HTTP_SERVLET_CONTEXT* pContext
					) __DCL_THROWS1(Exception*);
};

__DCL_END_NAMESPACE

#endif	// __DCL_HTTP_SERVLET_EX_H__
