#ifndef __DCL_HTTP_STREAM_H__
#define __DCL_HTTP_STREAM_H__	20060104

#ifndef __DCL_INPUT_STREAM_H__
#include <dcl/InputStream.h>
#endif
#ifndef __DCL_OUTPUT_STREAM_H__
#include <dcl/OutputStream.h>
#endif

__DCL_BEGIN_NAMESPACE

class HttpServletContext;

class DCLCAPI HttpInputStream : public InputStream
{
	DECLARE_CLASSINFO(HttpInputStream)
public:
	HttpInputStream(HttpServletContext* _ctx);

	virtual size_t read(void* _buf, size_t _n)
				__DCL_THROWS1(IOException*);

protected:
	HttpServletContext*	__ctx;
};

class DCLCAPI HttpOutputStream : public OutputStream
{
	DECLARE_CLASSINFO(HttpOutputStream)
public:
	HttpOutputStream(HttpServletContext* _ctx);

	virtual OutputStream& write(const void* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

private:
	HttpServletContext*	__ctx;
};

__DCL_END_NAMESPACE

#endif	// __DCL_HTTP_STREAM_H__

