#ifndef __DCL_INIFILE_H__
#define __DCL_INIFILE_H__

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif

#if __DCL_WINDOWS
#ifndef __DCL_REGISTRY_H__
#include <dcl/Registry.h>
#endif
#endif

__DCL_BEGIN_NAMESPACE

class DCLCAPI IniFile : public Object
{
	DECLARE_CLASSINFO(IniFile)
public:
	virtual String toString() const;
#if __DCL_DEBUG
	virtual void dump(Writer& out) const;
#endif

	IniFile(const String& strFileName)
		__DCL_THROWS1(IOException*);

	virtual ~IniFile();

	virtual void close()
		__DCL_THROWS1(IOException*);

	virtual String getString(
				const String& strSection,
				const String& strEntry, 
				const wchar_t* pszDefault = NULL
				) __DCL_THROWS1(IOException*);

	virtual int getInteger(
				const String& strSection,
				const String& strEntry, 
				int nDefault
				) __DCL_THROWS1(IOException*);

	virtual void setValue(
				const String& strSection,
				const String& strEntry, 
				const String& strValue
				) __DCL_THROWS1(IOException*);

	virtual void setValue(
				const String& strSection,
				const String& strEntry, 
				int nValue
				) __DCL_THROWS1(IOException*);

private:
	String __getValue(
				const String& strSection,
				const String& strEntry
				);

	void __setValue(
				const String& strSection,
				const String& strEntry,
				const String& strValue
				);

protected:
	Object*	m_handle;
	String	m_strName;
	bool	m_bModified;

	IniFile();
};

#if __DCL_WINDOWS

class DCLCAPI RegIniFile : public IniFile
{
	DECLARE_CLASSINFO(RegIniFile)
public:
	RegIniFile(HKEY hParentKey,	const String& strKey)
		__DCL_THROWS1(IOException*);

	virtual void close()
		__DCL_THROWS1(IOException*);

	virtual String getString(
				const String& strSection,
				const String& strEntry, 
				const wchar_t* pszDefault = NULL
				) __DCL_THROWS1(IOException*);

	virtual int getInteger(
				const String& strSection,
				const String& strEntry, 
				int nDefault
				) __DCL_THROWS1(IOException*);

	virtual void setValue(
				const String& strSection,
				const String& strEntry, 
				const String& strValue
				) __DCL_THROWS1(IOException*);

	virtual void setValue(
				const String& strSection,
				const String& strEntry, 
				int nValue
				) __DCL_THROWS1(IOException*);

protected:
	Registry	m_reg;
};
#endif

__DCL_END_NAMESPACE

#endif	// __DCL_INIFILE_H__

