#ifndef __DCL_INPUT_STREAM_H__
#define __DCL_INPUT_STREAM_H__		20071009

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * 바이트 스트림을 읽기위한 최상위 추상클래스이다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 1.0
 *
 * @see		OutputStream
 * @see		InputStreamReader
 */
class DCLCAPI InputStream : public Object
{
	DECLARE_CLASSINFO(InputStream)
public:

	/**
	 * 스트림을 닫는다.
	 * <p>이것의 기본 구현은 아무런 행위가 없다. 파생클래스는 스트림을 닫기위해 이것을 override한다.</p>
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 *	Non-Block으로 읽혀질 수 있는 바이트의 수를 리턴한다.
	 * <p>이것의 기본구현은 0을 리턴한다.
	 * 파생클래스는 {@link InputStreamReader}를 위하여 이것을 override하여야 한다.</p>
	 */
	virtual size_t available() const
			__DCL_THROWS1(IOException*);

#if 0
	virtual size_t peek(void* p, size_t _nbytes)
			__DCL_THROWS1(IOException*) = 0;
#endif
	/**
	 * _n바이트의 데이터를 읽는다. 
	 * <p>패생클래스는 1번 이상 블록되지 않도록 구현하여야 한다.</p>
	 *
	 * @param _buf
	 *		버퍼
	 * @param _n
	 *		버퍼의 크기가 _n바이트
	 * @return
	 *		읽혀진 바이트의 수이다. 0이면 EOF이다.
	 */
	virtual size_t read(void* _buf, size_t _n) 
			__DCL_THROWS1(IOException*) = 0;
};

__DCL_END_NAMESPACE

#endif	// __DCL_INPUT_STREAM_H__

