#ifndef __DCL_INPUT_STREAM_READER_H__
#define __DCL_INPUT_STREAM_READER_H__	20110130

#ifndef __DCL_READER_H__
#include <dcl/Reader.h>
#endif
#ifndef __DCL_INPUT_STREAM_H__
#include <dcl/InputStream.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * 바이트 스트림으로 부터 wchar_t 스트림 사이의 다리역할을 한다.
 *
 * @author	Daejung Kim
 * @since	DCL Version 3.0
 *
 * @see		InputStream
 * @see		CharsetCodec
 */

class CharsetDecoder;

class DCLCAPI InputStreamReader : public Reader
{
	DECLARE_CLASSINFO(InputStreamReader)
protected:
	/**
	 * 파생클래스를 위한 생성자이다.
	 */
	InputStreamReader();

public:
	/**
	 * 객체의 구성에 대하여 간략한 요약을 리턴한다.
	 */
	virtual String toString() const;

	/**
	 * 참조된 스트림과 디코더로 객체를 구성한다.
	 * _input과 _decoder는 객체의 생명주기동안 유효해야 하며,
	 * _input은 {@link #close()}에서 close하지 않는다.
	 *
	 * @param _input
	 *		A InputStream
	 * @param _decoder
	 *		A CharsetDecoder
	 */
	InputStreamReader(
		InputStream&		__noclose__ _input,
		CharsetDecoder&		_decoder
		);

	/**
	 * 넘겨받은 스트림과 디코더로 객체를 구성한다.
	 * {@link #close()}에서 _pInput의 close()가 호출되고 pInput과 _pDecoder는 파괴된다.
	 *
	 * @param _pInput
	 *		A InputStream
	 * @param _pDecoder
	 *		NULL이면 처음 읽는 2~4바이트를 사용하여 BOM을 검사 한 후, 확인이 안되면 LocaleEncoder를 사용한다.
	 */
	InputStreamReader(
		InputStream*		__destroy__ _pInput,			// new InputStream
		CharsetDecoder*		__destroy__ _pDecoder = NULL	// new CharsetDecoder
		) __DCL_THROWS1(IOException*);

	/**
	 * 객체의 파괴를 수행한다.
	 * close하지 않았으면 {@link #close()}하며 예외가 발생하면 무시한다.
	 */
	virtual ~InputStreamReader();

	/**
	 * 객체를 닫는다. 넘겨받은 InputStream과 CharsetDecoder는 파괴된다.
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 * 텍스트를 읽는다.
	 *
	 * @param _buf
	 *		버퍼
	 * @param _n
	 *		_buf의 길이, _buf가 가리키는 버퍼의 wchar_t의 개수
	 */
	virtual size_t read(wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

protected:
	InputStream*		__input;
	CharsetDecoder*		__decoder;
	bool				__closeDestroy;

private:
#define __EXTRA_MAX	16	// cf. MB_LEN_MAX
	byte_t				__extra[__EXTRA_MAX];
	size_t				__extraBytes;
};

__DCL_END_NAMESPACE

#endif		// __DCL_INPUT_STREAM_READER_H__
