#ifndef __DCL_LIST_BASE_H__
#define __DCL_LIST_BASE_H__		20110303

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>		// for __DCL_ASSERT
#endif

__DCL_BEGIN_NAMESPACE

#if __DCL_DEBUG
	static const char_t __szListBase_h__[] = __T("dcl/ListBase.h");
	#undef __THIS_FILE__
	#define __THIS_FILE__ __szListBase_h__
#endif

struct DCLCAPI NodeBase
{
	NodeBase* pPrev;
	NodeBase* pNext;
};

class ConstListIteratorBase;
class DCLCAPI ListIteratorBase
{
public:
	bool operator == (const ListIteratorBase& x) const;
	bool operator != (const ListIteratorBase& x) const;

protected:
	NodeBase*	__pNode;
	friend class ConstListIteratorBase;
};

class DCLCAPI ConstListIteratorBase
{
public:
	bool operator == (const ConstListIteratorBase& x) const;
	bool operator != (const ConstListIteratorBase& x) const;

	bool operator == (const ListIteratorBase& x) const;
	bool operator != (const ListIteratorBase& x) const;

protected:
	const NodeBase*	__pNode;
};

inline bool 
ListIteratorBase::operator == (const ListIteratorBase& x) const
{
	__DCL_ASSERT(__pNode != NULL);
	__DCL_ASSERT(x.__pNode != NULL);
	return __pNode == x.__pNode;
}

inline bool
ListIteratorBase::operator != (const ListIteratorBase& x) const
{
	__DCL_ASSERT(__pNode != NULL);
	__DCL_ASSERT(x.__pNode != NULL);
	return __pNode != x.__pNode;
}

inline bool ConstListIteratorBase::operator == (const ConstListIteratorBase& x) const
{
	__DCL_ASSERT(__pNode != NULL);
	__DCL_ASSERT(x.__pNode != NULL);
	return __pNode == x.__pNode;
}

inline bool ConstListIteratorBase::operator != (const ConstListIteratorBase& x) const
{
	__DCL_ASSERT(__pNode != NULL);
	__DCL_ASSERT(x.__pNode != NULL);
	return __pNode != x.__pNode;
}

inline bool ConstListIteratorBase::operator == (const ListIteratorBase& x) const
{
	__DCL_ASSERT(__pNode != NULL);
	__DCL_ASSERT(x.__pNode != NULL);
	return __pNode == x.__pNode;
}

inline bool ConstListIteratorBase::operator != (const ListIteratorBase& x) const
{
	__DCL_ASSERT(__pNode != NULL);
	__DCL_ASSERT(x.__pNode != NULL);
	return __pNode != x.__pNode;
}

#if __DCL_DEBUG
	#undef __THIS_FILE__
	#define __THIS_FILE__	__T(__FILE__)
#endif

__DCL_END_NAMESPACE

#endif		// __DCL_LIST_BASE_H__
