#ifndef __DCL_NUMERIC_H__
#define __DCL_NUMERIC_H__	20050305

#ifndef __DCL_CONFIG_H__
#include <dcl/Config.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif

__DCL_BEGIN_NAMESPACE

class Integer;
class UInteger;
class Int32;
class UInt32;
class Int64;
class UInt32;
class Single;
class Double;
class Decimal;

class DCLCAPI Integer
{
public:
	int		__n;

public:
	Integer(int _n);
	String toString(unsigned _base = 10) const;

	/**
	 * @param	_base	2 ~ 36
	 */
	static String toString(int _n, unsigned _base = 10);
	static String toString(int _n, const wchar_t* _format);

	static int parse(const wchar_t* _number, unsigned _base = 10)
					__DCL_THROWS1(NumericConvertException*);

	static int parse(const wchar_t* _number, unsigned _base, int _default);
};

class DCLCAPI UInteger
{
public:
	unsigned int		__u;

public:
	UInteger(unsigned int _u);
	String toString(unsigned _base = 10) const;
	/**
	 * @param	_base	2 ~ 36
	 */
	static String toString(unsigned int _u, unsigned _base = 10);
	static String toString(unsigned int _u, const wchar_t* _format);

	static unsigned int parse(const wchar_t* _number, unsigned _base = 10)
					__DCL_THROWS1(NumericConvertException*);

	static unsigned int parse(const wchar_t* _number, unsigned _base, unsigned int _default);
};

class DCLCAPI Int32
{
public:
	int32_t		__n;

public:
	Int32(int32_t _n);
	String toString(unsigned _base = 10) const;

	static String toString(int32_t _n, unsigned _base = 10);
	static String toString(int32_t _n, const wchar_t* _format);

	static int32_t parse(const wchar_t* _number, unsigned _base = 10)
					__DCL_THROWS1(NumericConvertException*);

	static int32_t parse(const wchar_t* _number, unsigned _base, int32_t _default);

	static ByteString toByteString(int32_t _n, unsigned _base = 10);
};

class DCLCAPI UInt32
{
public:
	uint32_t		__u;

public:
	UInt32(uint32_t _u);
	String toString(unsigned _base = 10) const;

	static String toString(uint32_t _u, unsigned _base = 10);
	static String toString(uint32_t _u, const wchar_t* _format);

	static uint32_t parse(const wchar_t* _number, unsigned _base = 10)
					__DCL_THROWS1(NumericConvertException*);

	static uint32_t parse(const wchar_t* _number, unsigned _base, uint32_t _default);

	static ByteString toByteString(uint32_t _u, unsigned _base = 10);
};

class DCLCAPI Int64
{
public:
	int64_t		__n;

public:
	Int64(int64_t _n);
	String toString(unsigned _base = 10) const;

	static String toString(int64_t _n, unsigned _base = 10);
	static String toString(int64_t _n, const wchar_t* _format);

	static int64_t parse(const wchar_t* _number, unsigned _base = 10)
					__DCL_THROWS1(NumericConvertException*);

	static int64_t parse(const wchar_t* _number, unsigned _base, int64_t _default);

	static ByteString toByteString(int64_t _n, unsigned _base = 10);
};

class DCLCAPI UInt64
{
public:
	uint64_t		__u;

public:
	UInt64(uint64_t _u);
	String toString(unsigned _base = 10) const;

	static String toString(uint64_t _u, unsigned _base = 10);
	static String toString(uint64_t _u, const wchar_t* _format);

	static uint64_t parse(const wchar_t* _number, unsigned _base = 10)
					__DCL_THROWS1(NumericConvertException*);

	static uint64_t parse(const wchar_t* _number, unsigned _base, uint64_t _default);

	static ByteString toByteString(uint64_t _u, unsigned _base = 10);
};

class DCLCAPI Single
{
public:
	float		__f;

public:
	Single(float _f);
	String toString() const;
#if 0
	// use gcvt
	static String toString(float _f);
#endif
	// use String::format
	static String toString(float _f, const wchar_t* _format);

	// _number  
	//	- glibc : decimal, hex-decimal, infinite or NAM(not-a-number)
	//	- msvcrt : decimal
	static float parse(const wchar_t* _number)
					__DCL_THROWS1(NumericConvertException*);

	static float parse(const wchar_t* _number, float _default);

	static ByteString toByteString(float _f, const char* _format);
};

class DCLCAPI Double
{
public:
	double		__d;

public:
	Double(double _d);
	String toString() const;
#if 0
	// use gcvt
	static String toString(double _d);
#endif
	// use String::format
	static String toString(double _d, const wchar_t* _format);

	static double parse(const wchar_t* _number)
					__DCL_THROWS1(NumericConvertException*);

	static double parse(const wchar_t* _number, double _default);

	static ByteString toByteString(double _f, const char* _format);
};

class DCLCAPI Decimal
{
protected:
	String m_value;
public:
	Decimal();
	Decimal(const Decimal& value);
#if 0
	Decimal(int _n);
	Decimal(unsigned int _u);
#endif
	Decimal(int32_t _n);
	Decimal(uint32_t _u);
	Decimal(int64_t _n);
	Decimal(uint64_t _u);
	Decimal(float f);
	Decimal(double d);
	Decimal(const String& strNumber);

	void assign(const wchar_t* _number, int _n);

	const Decimal& operator = (const Decimal& value);
#if 0
	const Decimal& operator = (int _n);
	const Decimal& operator = (unsigned int _u);
#endif
	const Decimal& operator = (int32_t _n);
	const Decimal& operator = (uint32_t _u);
	const Decimal& operator = (int64_t _n);
	const Decimal& operator = (uint64_t _u);

	const Decimal& operator = (float value);
	const Decimal& operator = (double value);

	const Decimal& operator = (const String& strNumber);

	static const char* FORMAT_STRING;	// "#,###.####"

	String toString() const;
	String toStringF(const char* pszDecimalFormat = NULL) const;
	

	static String toString(const Decimal& value);
	static String toStringF(const Decimal& value,
				const char* pszDecimalFormat = NULL);
	};

#include <dcl/Numeric.inl>

__DCL_END_NAMESPACE

#endif	// __DCL_NUMERIC_H__
