#ifndef __DCL_NUMERIC_H__
	#error "Never use <dcl/core/Numeric.inl> directly; include <dcl/core/Numeric.h> instead."
#endif
#ifndef __DCL_NUMERIC_INL__
#define __DCL_NUMERIC_INL__

#ifndef __WORDSIZE
#error	"must defined __WORDSIZE"
#endif

#if !(__WORDSIZE == 32 || __WORDSIZE == 64)
#error "unsupported __WORDSIZE"
#endif

///////////// Integer /////////////
inline Integer::Integer(int _n)
{
	__n = _n;
}

inline String Integer::toString(unsigned _base) const
{
	return Integer::toString(__n, _base);
}

inline String Integer::toString(int _n, unsigned _base)
{
	return Int32::toString((int32_t) _n, _base);
}

inline String Integer::toString(int _n, const wchar_t* _format)
{
	return Int32::toString((int32_t)_n, _format);
}

inline int Integer::parse(const wchar_t* _number, unsigned _base)
				__DCL_THROWS1(NumericConvertException*)
{
	return Int32::parse(_number, _base);
}

inline int Integer::parse(const wchar_t* _number, unsigned _base, int _default)
{
	return Int32::parse(_number, _base, _default);
}

///////////// UInteger /////////////

inline UInteger::UInteger(unsigned int _u)
{
	__u = _u;
}

inline String UInteger::toString(unsigned _base) const
{
	return UInteger::toString(__u, _base);
}

inline String UInteger::toString(unsigned int _u, unsigned _base)
{
	return UInt32::toString((uint32_t)_u, _base);
}

inline String UInteger::toString(unsigned int _u, const wchar_t* _format)
{
	return UInt32::toString((uint32_t)_u, _format);
}

inline unsigned int UInteger::parse(const wchar_t* _number, unsigned _base)
				__DCL_THROWS1(NumericConvertException*)
{
	return UInt32::parse(_number, _base);
}

inline unsigned int UInteger::parse(const wchar_t* _number, unsigned _base, unsigned int _default)
{
	return UInt32::parse(_number, _base, _default);
}

///////////// Int32 /////////////

inline Int32::Int32(int32_t _n)
{
	__n = _n;
}

inline String Int32::toString(unsigned _base) const
{
	return Int32::toString(__n, _base);
}

///////////// UInt32 /////////////

inline UInt32::UInt32(uint32_t _u)
{
	__u = _u;
}

inline String UInt32::toString(unsigned _base) const
{
	return UInt32::toString(__u, _base);
}

/////////////// Int64 /////////////////

inline Int64::Int64(int64_t _n)
{
	__n = _n;
}

inline String Int64::toString(unsigned _base) const
{
	return Int64::toString(__n, _base);
}

/////////////// UInt64 /////////////////

inline UInt64::UInt64(uint64_t _u)
{
	__u = _u;
}

inline String UInt64::toString(unsigned _base) const
{
	return UInt64::toString(__u, _base);
}

/////////////// Single /////////////////

inline Single::Single(float _f)
{
	__f = _f;
}

inline String Single::toString() const
{
	return Single::toString(__f, NULL);
}

///////// Double //////////

inline Double::Double(double _d)
{
	__d = _d;
}

inline String Double::toString() const
{
	return Double::toString(__d, NULL);
}

////////// Decimal ///////////
inline Decimal::Decimal()
{
}

inline Decimal::Decimal(const Decimal& value)
	: m_value(value.m_value)
{
}
#if 0
inline Decimal::Decimal(int _n)
{
	*this = _n;
}

inline Decimal::Decimal(unsigned int _u)
{
	*this = _u;
}
#endif
inline Decimal::Decimal(int32_t _n)
{
	*this = _n;
}

inline Decimal::Decimal(uint32_t _u)
{
	*this = _u;
}

inline Decimal::Decimal(int64_t _n)
{
	*this = _n;
}

inline Decimal::Decimal(uint64_t _u)
{
	*this = _u;
}

inline Decimal::Decimal(float f)
{
	*this = f;
}

inline Decimal::Decimal(double d)
{
	*this = d;
}

inline Decimal::Decimal(const String& strNumber)
	: m_value(strNumber)
{
}

inline void Decimal::assign(const wchar_t* _number, int _n)
{
	m_value.assign(_number, _n);
}

inline const Decimal& Decimal::operator = (const Decimal& value)
{
	m_value = value.m_value;
	return *this;
}

#if 0
inline const Decimal& Decimal::operator = (int _n)
{
#if __WORDSIZE == 64
	*this = (int64_t)_n;
#else
	*this = (int32_t)_n;
#endif
	return *this;
}

inline const Decimal& Decimal::operator = (unsigned int _u)
{
#if __WORDSIZE == 64
	*this = (uint64_t)_u;
#else
	*this = (uint32_t)_u;
#endif
	return *this;
}
#endif

inline const Decimal& Decimal::operator = (int32_t _n)
{
	m_value = Int32::toString(_n, 10);
	return *this;
}

inline const Decimal& Decimal::operator = (uint32_t _u)
{
	m_value = UInt32::toString(_u, 10);
	return *this;
}

inline const Decimal& Decimal::operator = (int64_t _n)
{
	m_value = Int64::toString(_n, 10);
	return *this;
}

inline const Decimal& Decimal::operator = (uint64_t _u)
{
	m_value = UInt64::toString(_u, 10);
	return *this;
}

inline const Decimal& Decimal::operator = (const String& strNumber)
{
	m_value = strNumber;
	return *this;
}

inline String Decimal::toString() const
{
	return m_value;
}

inline String Decimal::toStringF(
				const char* pszDecimalFormat // = FORMAT_DEFAULT
				) const
{
	return Decimal::toStringF(*this, pszDecimalFormat);
}

#endif	// __DCL_NUMERIC_INL__


