#ifndef __DCL_OBJECT_H__
#define __DCL_OBJECT_H__		20050517

//#include <stdio.h>

#ifndef __cplusplus
#error "dcl/Object.h requires C++ Complilation"
#endif

#ifndef __DCL_CONFIG_H__
#include <dcl/Config.h>
#endif

#ifndef __DCL_NO_RTTI
#include <typeinfo>
#endif

#if __DCL_HAVE_ALLOC_DEBUG && !(__DCL_DEBUG)
#error "dcl/_Config.h incorrect"
#endif

#ifdef __DCL_DEBUG_NEW
#error "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
#undef new
#endif

#undef __CONCAT__
#undef __CONCAT

#undef __STRING__

#undef __TEXT__
#undef __TEXT
#undef __T
#undef _T

#define __CONCAT__(x, y)			x##y
#define __CONCAT(x, y)				__CONCAT__(x, y)

#define __STRING__(expr)			#expr

#define __TEXT__(str)				L##str
#define __TEXT(str)					__TEXT__(str)
#define __T(str)					__TEXT__(str)
#define _T(str)						__TEXT__(str)

#define __CONCAT_TEXT(str, expr)	__TEXT(str) __STRING__(expr)

#if 0
// Test text-macros
#define BB bb

__CONCAT(aa, BB)
__STRING__(aa == b)

__TEXT("aa")
__T("aa")

__CONCAT_TEXT("aa", BB)
#endif

__DCL_BEGIN_NAMESPACE

/*
DCLCore classes

Object;
	Exception;
		IOException;
		DllException;
		AssertError;
		SQLException;
	InputStream;
		FileInputStream;
	OutputStream;
		ByteOutputStream;
			XByteOutputStream;
		FileOutputStream;
			XFileOutputStream;
	File;
	StdFile;
	Thread;
		MThread;	// Message
	Dll;
		SQLDriver;
	SQLField;
		SQLParam;
	SQLQuery;
	SQLConnection;
	SQLConnectionPool;
	HtmlTemplate;
#if __DCL_WINDOWS
	WinRegistry;
#endif
	IniFile;
	Regex;

String;
Date;
Time;
DateTime;
Interval;
Int32;
Int64;
Single;
Double;
Decimal;
	
SyncObject;
	Mutex;
	ThreadCond;
*/

class String;
class Writer;

class DCLCAPI Object
{
protected:
	virtual ~Object();
	Object();

public:
	virtual String toString() const;

#if __DCL_DEBUG
	virtual void dump(Writer& out) const;
#endif
	/**
	파생클래스에서 new 연산자를 override했거나,
	추가적인 행위가 필요하다면 이것도 override하라
	*/
	virtual void destroy();

#if __DCL_HAVE_ALLOC_DEBUG
	void* operator new(
				size_t			_size,
				bool			_check,
				const char_t*	_filename,
				unsigned int	_line
				);

	void* operator new[](
				size_t			_size,
				bool			_check,
				const char_t*	_filename,
				unsigned int	_line
				);

	void operator delete(
				void*			_ptr,
				bool,			// _check
				const char_t*	_filename,
				unsigned int	_line
				);

	void operator delete[](
				void*			_ptr,
				bool,			// _check
				const char_t*	_filename,
				unsigned int	_line
				);

	void* operator new(size_t);
	void* operator new[](size_t);

	void operator delete(void* _ptr);
	void operator delete[](void* _ptr);

	// default placement
	void* operator new(size_t, void* _ptr){	return _ptr; }
	void* operator new[](size_t, void* _ptr) { return _ptr; }
	void operator delete(void*, void*) { }
	void operator delete[](void*, void*) { }
#endif

public:
	String className() const;

#ifdef __DCL_NO_RTTI
	struct DCLCAPI ClassInfo
	{
		const wchar_t*		pszClassName;
		size_t				nObjectSize;
		const ClassInfo*	pBaseClassInfo;
	};
	static const ClassInfo m_classInfo;

	// 인스턴스의 클래스가 pClassInfo이거나 pClassInfo로부터 상속받은 클래스이면 true
	bool isKindOf(const ClassInfo* pClassInfo) const;
	// pClassInfo의 인스턴스이면 true
	bool isInstanceOf(const ClassInfo* pClassInfo) const;
	virtual const ClassInfo* classInfo() const;
#else
	bool isInstanceOf(const std::type_info& typeinfo) const;
	virtual const std::type_info& typeInfo() const;
#endif
};

#ifdef __DCL_NO_RTTI
#define CLASSINFO_REF	const Object::ClassInfo*
#define CLASSINFO(class_name) (&class_name::m_classInfo)
#define DECLARE_CLASSINFO(class_name) \
public: \
	static const ClassInfo m_classInfo; \
	virtual const ClassInfo* classInfo() const;
#else
#define CLASSINFO_REF	const std::type_info&
#define CLASSINFO(class_name) (typeid(class_name))
#define DECLARE_CLASSINFO(class_name) \
public: \
	virtual const std::type_info& typeInfo() const; 
#endif

#ifdef __DCL_NO_RTTI
#define IMPLEMENT_CLASSINFO(class_name, base_class_name) \
const Object::ClassInfo class_name::m_classInfo = \
{ \
	__DCL_NAMESPACE_STRING __S(class_name), \
	sizeof(class class_name), \
	&base_class_name::m_classInfo \
}; \
const Object::ClassInfo* class_name::classInfo() const \
{ \
	return CLASSINFO(class_name); \
}
#else
#define IMPLEMENT_CLASSINFO(class_name, base_class_name) \
const std::type_info& class_name::typeInfo() const \
{ \
	return typeid(class_name); \
}
#endif

__DCL_END_NAMESPACE

#if __DCL_DEBUG
#define DCLInitialize	DCLInitializeD
#define DCLCleanup		DCLCleanupD
#endif

#if __DCL_HAVE_MANUAL_INITIALIZE
/**
 * 라이브러리 환경을 초기화 한다.
 * <ul>
 *    <li>UNIX의 pthread 관련 자원의 초기화</li>
 *    <li>디버깅 환경의 초기화</li>
 * </ul>
 * @return 이 함수의 호출 카운트를 리턴한다.
 */
DCLCAPI int DCLInitialize();

/**
 * 라이브러리 환경을 파괴한다.
 * </p>이 과정에는 동적으로 할당된 자원을 제거하는 다음의 절차들이 있다.</p>
 * <ul>
 *    <li>적재된 데이터베이스 드라이버의 제거</li>
 *    <li>Windows WSACleanup()의 호출</li>
 *    <li>디버깅 환경의 제거</li>
 *    <li>UNIX의 pthread 관련 자원의 해제</li>
 * </ul>
 */
DCLCAPI void DCLCleanup();

#define __DCL_INITIALIZE	DCLInitialize();
#define __DCL_CLEANUP		DCLCleanup();
#else
#define __DCL_INITIALIZE
#define __DCL_CLEANUP
#endif

//typedef void (* DCLCleanupCallback)(void*);
typedef void (* DCLCleanupCallback)();


#if __DCL_DEBUG
/**
 * DCLDebugTrace의 프로세스 출력을 설정한다.
 * <p>스레드간 동기화는 내부적으로 구현하고 있으므로,
 * XWriter와 같이 동기화된 객체를 사용할 필요가 없다.</p>
 * @param _pWriter
 *		Writer의 인스턴스 포인터이다. NULL이면 출력을 중단한다.
 * @return
 *		이전 설정값을 반환한다.
 */
DCLCAPI __DCL_NAMESPACE Writer* DCLDebugSetGlobalReport(
				__DCL_NAMESPACE Writer* __noclose__ _pWriter
				);

/**
 * DCLDebugTrace의 스레드 출력을 설정한다.
 * @param _pWriter
 *		Writer의 인스턴스 포인터이다. NULL이면 출력을 중단한다.
 * @return
 *		이전 설정값을 반환한다.
 */
DCLCAPI __DCL_NAMESPACE Writer* DCLDebugSetThreadReport(
				unsigned long uThreadId,
				__DCL_NAMESPACE Writer* __noclose__ _pWriter
				);

/**
 * AssertError* 예외를 던진다.
 */
DCLCAPI void DCLDebugAssert(
				const char_t*		_filename, 
				unsigned int		_line,
				const char_t*		_expr,
				const char_t*		_message
				) __DCL_THROWS1(__DCL_NAMESPACE AssertError*);

/**
 * 추적 문자열을 출력한다.
 */
DCLCAPI void DCLDebugTrace(
				const char_t*		_filename,
				unsigned int		_line,
				const char_t*		_format,
				...
				);
#endif		/*	__DCL_DEBUG */


/*****************************************************
	MACRO FOR ASSERT/TRACE
*****************************************************/

#undef ASSERT
#undef ASSERT_EX
#undef VERIFY

#define ASSERT		__DCL_ASSERT
#define ASSERT_EX	__DCL_ASSERT_EX
#define VERIFY		__DCL_VERIFY

#undef TRACE0
#undef TRACE1
#undef TRACE2
#undef TRACE3
#undef TRACE4

#define TRACE0		__DCL_TRACE0
#define TRACE1		__DCL_TRACE1
#define TRACE2		__DCL_TRACE2
#define TRACE3		__DCL_TRACE3
#define TRACE4		__DCL_TRACE4

#if __DCL_DEBUG

#define __DCL_ASSERT(expr) \
	(expr) ? (void) 0 : DCLDebugAssert(__THIS_FILE__, __LINE__, __T(#expr), NULL)

#define __DCL_ASSERT_EX(expr, msg) \
	(expr) ? (void) 0 : DCLDebugAssert(__THIS_FILE__, __LINE__, __T(#expr), msg)

#define __DCL_VERIFY(expr) __DCL_ASSERT(expr)

#define __DCL_TRACE0(psz) \
			DCLDebugTrace(__THIS_FILE__, __LINE__, psz)		
#define __DCL_TRACE1(fmt, arg1) \
			DCLDebugTrace(__THIS_FILE__, __LINE__, fmt, arg1)
#define __DCL_TRACE2(fmt, arg1, arg2) \
			DCLDebugTrace(__THIS_FILE__, __LINE__, fmt, arg1, arg2)
#define __DCL_TRACE3(fmt, arg1, arg2, arg3) \
			DCLDebugTrace(__THIS_FILE__, __LINE__, fmt, arg1, arg2, arg3)
#define __DCL_TRACE4(fmt, arg1, arg2, arg3, arg4) \
			DCLDebugTrace(__THIS_FILE__, __LINE__, fmt, arg1, arg2, arg3, arg4)

#else	/* __DCL_DEBUG */

#define __DCL_ASSERT(expr)			((void)0)
#define __DCL_ASSERT_EX(expr, msg)	((void)0)
#define __DCL_VERIFY(expr)			((void)(expr))

#define __DCL_TRACE0(psz)
#define __DCL_TRACE1(fmt, arg1)
#define __DCL_TRACE2(fmt, arg1, arg2)
#define __DCL_TRACE3(fmt, arg1, arg2, arg3)
#define __DCL_TRACE4(fmt, arg1, arg2, arg3, arg4)

#endif	/* __DCL_DEBUG */

#define __DCL_ASSERT_HANDLE(expr)	__DCL_ASSERT(expr)
#define __DCL_ASSERT_PARAM(expr)	__DCL_ASSERT(expr)

#include <new>

#if __DCL_HAVE_ALLOC_DEBUG

typedef enum {
	DCL_ALLOC_DEFAULT,				/* malloc, calloc, reallc, free			*/
	DCL_ALLOC_NEW,					/* new char, new int, new struct, ...	*/
	DCL_ALLOC_NEW_ARRAY,			/* new char[], new int[], ...			*/
	DCL_ALLOC_NEW_OBJECT,			/* new Object							*/
	DCL_ALLOC_NEW_OBJECT_ARRAY,		/* new Object[]							*/
	DCL_ALLOC_DELETE,				/* delete ptr							*/
	DCL_ALLOC_DELETE_ARRAY,			/* delete[] ptr							*/
	DCL_ALLOC_DELETE_OBJECT,		/* delete (Object*)						*/
	DCL_ALLOC_DELETE_OBJECT_ARRAY	/* delete[] (Object*)					*/
} DCLAllocFunction;

/**
 * new, new[] 위치를 정할 수 없을 때, 진입 위치를 지정한다.
*/
DCLCAPI void DCLDebugAllocEnterNear(
			const char_t* _filename,
			unsigned int	_line
		);

DCLCAPI void* DCLDebugMalloc(
			size_t			_size,
			bool			_check,
			DCLAllocFunction allocFunction,
			const char_t*	_filename,
			unsigned int	_line
		);

DCLCAPI void DCLDebugFree(
			void*			_ptr, 
			DCLAllocFunction allocFunction,
			const char_t*	_filename,
			unsigned int	_line
		);

DCLCAPI void* DCLDebugCalloc(
			size_t			_count,
			size_t			_size,
			bool			_check,
			const char_t*	_filename,
			unsigned int	_line
		);

DCLCAPI void* DCLDebugRealloc(
			void*			_ptr, 
			size_t			_newsize,
			bool			_check,
			const char_t*	_filename,
			unsigned int	_line
		);

DCLCAPI bool DCLDebugAllocIsValid(
			const void*		_ptr
		);

DCLCAPI void DCLDebugAllocSetCheckFlag(
			const void*		_ptr,
			bool			_check
		);

/**
 * _p가 할당된 위치를 반환한다.
*/
DCLCAPI bool DCLDebugAllocGetPosition(
			const void*		_ptr,
			char_t*			_pfilename,
			size_t			_count,
			unsigned int*	_pline
		);

/** 
 *return : uThreadId가 할당한 마지막 포지션 항목이 없으면 NULL
*/
DCLCAPI const void* DCLDebugGetLastAllocPosition(
			unsigned long uThreadId
		);

typedef enum {
	DCL_ALLOC_DUMP_ALL	= 0,
	DCL_ALLOC_DUMP_INTERNAL,
	DCL_ALLOC_DUMP_USER
} DCLAllocLeakDumpLevel;

/* 
uThreadId가 할당한 pvStartPosition에서 최근까지의 메모리 누출 보고
return : 성공하면 메모리 누출 항목의 갯수 >= 0, 실패(-1) 출력을 위한 버퍼할당 오류
*/
DCLCAPI size_t DCLDebugDumpThreadMemoryLeak(
			unsigned long uThreadId,
			const void* pvStartPosition,
			DCLAllocLeakDumpLevel level,
			__DCL_NAMESPACE Writer* pWriter
		);

/*
프로세스가 할당한 전체 메모리 누출 보고
return : 성공하면 메모리 누출 항목의 갯수 >= 0, 실패(-1) 출력을 위한 버퍼할당 오류
*/
DCLCAPI size_t DCLDebugDumpGlobalMemoryLeak(
			DCLAllocLeakDumpLevel level,
			__DCL_NAMESPACE Writer* pWriter
		);

/*****************************************************
	NEW/DELETE FOR ALLOC DEBUG
*****************************************************/

// Global new/delete Operator Overload
DCLCAPI void* operator new(
			size_t				_size,
			bool				_check,
			const char_t*		_filename,
			unsigned int		_line
		);

DCLCAPI void* operator new[](
			size_t				_size,
			bool				_check,
			const char_t*		_filename,
			unsigned int		_line
		);

DCLCAPI void operator delete(
			void*				_ptr, 
			bool				_check,
			const char_t*		_filename, 
			unsigned int		_line
		);

DCLCAPI void operator delete[](
			void*				_ptr,
			bool				_check,
			const char_t*		_filename,
			unsigned int		_line
		);

// 원칙적으로 위 연산자를 사용하는 구현과, 아래의 그렇지 않은 구현이
// 같은 프로세스에서 사용할 수 없다.
#if __DCL_WINDOWS
// MinGW gcc, clang 포함하여,
// VC++의 기본 new/delete 연산자는 dllexport로 컴파일 될 수 없다.

#undef __THIS_FILE__
static const char_t __szObject_h[] = __T("dcl/Object.h");
#define __THIS_FILE__ __szObject_h

#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable:4595)
#endif
inline void* operator new(size_t _size)
{
	void* r = DCLDebugMalloc(
			_size == 0 ? 1 : _size,
			true,
			DCL_ALLOC_NEW,
			NULL,
			0
		);
	//fprintf(stderr, "%s:%d[%zd][%p]\n", __FILE__, __LINE__, _size, r);
	return r;
}

inline void* operator new[](size_t _size)
{
	void* r = DCLDebugMalloc(
			_size == 0 ? 1 : _size,
			true,
			DCL_ALLOC_NEW_ARRAY,
			NULL,
			0
		);
	//fprintf(stderr, "%s:%d[%zd][%p]\n", __FILE__, __LINE__, _size, r);
	return r;
}

inline void operator delete(void* _ptr)
{
	//fprintf(stderr, "%s:%d[%p]\n", __FILE__, __LINE__, _ptr);
	DCLDebugFree(_ptr, DCL_ALLOC_DELETE, NULL, 0);
}

inline void operator delete[](void* _ptr)
{
	//fprintf(stderr, "%s:%d[%p]\n", __FILE__, __LINE__, _ptr);
	DCLDebugFree(_ptr, DCL_ALLOC_DELETE_ARRAY, NULL, 0);
}
#ifdef _MSC_VER
#pragma warning(pop)
#endif
#else
// GCC에서 delete를 inline으로 하면 컴파일러가 제공하는 delete가 호출된다.
DCLCAPI void* operator new(size_t _size);
DCLCAPI void* operator new[](size_t _size);
DCLCAPI void operator delete(void* _ptr);
DCLCAPI void operator delete[](void* _ptr);
#endif

// for default placement
//#if __GNUC__ >=3 || _MSC_VER >= 1200
/*
inline void* operator new(size_t, void* _ptr){	return _ptr; }
inline void* operator new[](size_t, void* _ptr) { return _ptr; }
inline void operator delete(void*, void*) { }
inline void operator delete[](void*, void*) { }
*/
//#else
//#include <new>
//#endif

//#else	/* __DCL_HAVE_ALLOC_DEBUG */
//#include <new>

#endif		/* __DCL_HAVE_ALLOC_DEBUG */

/*****************************************************
	MACRO FOR ALLOC DEBUG
*****************************************************/

#if __DCL_HAVE_ALLOC_DEBUG

#define __DCL_ALLOC_INTERNAL	false
#define __DCL_ALLOC_USER		true
#define __DCL_ALLOC_LEVEL		__DCL_ALLOC_USER

#define __DCL_DEBUG_NEW \
			new(__DCL_ALLOC_LEVEL, __THIS_FILE__, __LINE__)
#define __DCL_DEBUG_MALLOC(size)	\
			DCLDebugMalloc(size, __DCL_ALLOC_LEVEL, DCL_ALLOC_DEFAULT, __THIS_FILE__, __LINE__)
#define __DCL_DEBUG_CALLOC(count, size) \
			DCLDebugCalloc(count, size, __DCL_ALLOC_LEVEL, __THIS_FILE__, __LINE__)
#define __DCL_DEBUG_REALLOC(ptr, size) \
			DCLDebugRealloc(ptr, size, __DCL_ALLOC_LEVEL, __THIS_FILE__, __LINE__)
#define __DCL_DEBUG_FREE(ptr) \
			DCLDebugFree(ptr, DCL_ALLOC_DEFAULT, __THIS_FILE__, __LINE__)

#define new	__DCL_DEBUG_NEW
#define malloc(size)			__DCL_DEBUG_MALLOC(size)
#define calloc(count, size)		__DCL_DEBUG_CALLOC(count, size)
#define realloc(ptr, size)		__DCL_DEBUG_REALLOC(ptr, size)
#define free(ptr)				__DCL_DEBUG_FREE(ptr)

/* macro disable
#undef new
#undef malloc
#undef calloc
#undef realloc
#undef free
*/

#endif	// __DCL_HAVE_ALLOC_DEBUG

#ifdef __DCL_HAVE_ALLOC_DEBUG
#define __DCL_DEBUG_ALLOC_ENTER		DCLDebugAllocEnterNear(__THIS_FILE__, __LINE__)
#define __DCL_DEBUG_ALLOC_LEAVE		DCLDebugAllocEnterNear(NULL, 0)
#else
#define __DCL_DEBUG_ALLOC_ENTER
#define __DCL_DEBUG_ALLOC_LEAVE
#endif

#undef __THIS_FILE__
#define __THIS_FILE__	__T(__FILE__)

#endif	// __DCL_OBJECT_H__
