#ifndef __DCL_OUTPUT_STREAM_H__	
#define __DCL_OUTPUT_STREAM_H__		20071009

#ifndef __DCL_INCLUDED_STDARG_H
#include <stdarg.h>
#define __DCL_INCLUDED_STDARG_H
#endif

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * 바이트 스트림을 쓰기 위한 최상위 추상클래스이다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 1.0
 *
 * @see		InputStream
 * @see		OutputStreamWriter
 */
class DCLCAPI OutputStream : public Object
{
	DECLARE_CLASSINFO(OutputStream)
public:
	/**
	 * 스트림을 닫는다.
	 * 이것의 기본 구현은 아무런 행위가 없다. 파생클래스는 스트림을 닫기위해 이것을 override한다.
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 * 스트림이 버퍼링을 한다면 이를 내보낸다.
	 * 이것의 기본 구현은 아무런 행위가 없다. 파생클래스는 스트림을 닫기위해 이것을 override한다.
	 */
	virtual void flush()
			__DCL_THROWS1(IOException*);

	/**
	 * _n바이트의 데이터를 스트림에 write한다.
	 * 파생클래스는 _n바이트를 write하는 것에 대하여 보장하도록 구현해야 한다.
	 *
	 * @param _buf
	 *		버퍼
	 * @param _n
	 *		버퍼의 크기가 _n바이트
	 * @return
	 *		OutputStream&
	 */
	virtual OutputStream& write(const void* _buf, size_t _n)
			__DCL_THROWS1(IOException*) = 0;
	
	/**
	 * 형식화된 문자열을 출력한다.
	 * @param _format
	 *		포멧 문자열. %s는 %hs로 해석된다.
	 * @param _arglist
	 *		아귀먼트 리스트
	 * @return
	 *		출력된 총 바이트수를 반환한다.
	 */
	virtual int vprintf(const char* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

	/**
	 * 형식화된 문자열을 출력한다. 이 메소드는 내부적으로 vprintf를 호출한다.
	 */
	int printf(const char* _format, ...)
			__DCL_THROWS1(IOException*);
};

struct DCLCAPI __endl
{
	char __dummy;
	__endl() { }
};

#if defined(__GNUC__) || defined(_WIN64)
extern DCLCVAR const struct __endl endl;
#else
DCLCAPI const struct __endl endl();
#define endl endl()
#endif

#if __DCL_DEBUG
static const char_t* __pszOutputStream_h__ = __T("dcl/OutputStream.h");
#undef __THIS_FILE__
#define __THIS_FILE__ __pszOutputStream_h__
#endif

DCLCAPI OutputStream& operator << (OutputStream& out, const __endl&)
		__DCL_THROWS1(IOException*);

DCLCAPI inline OutputStream& operator << (OutputStream& _out, const char* _psz)
		__DCL_THROWS1(IOException*)
{
	__DCL_ASSERT(_psz != NULL);
	return _out.write(_psz, ByteString::length(_psz));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, const ByteString& _str)
		__DCL_THROWS1(IOException*)
{
	return _out.write(_str.data(), _str.length());
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, const ByteStringBuilder& _sb)
__DCL_THROWS1(IOException*)
{
	return _out.write(_sb.data(), _sb.length());
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, char _ch)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_ch, sizeof(char));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, unsigned char _ch)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_ch, sizeof(unsigned char));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, short int _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, unsigned short int _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, int _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, unsigned int _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, long _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, unsigned long _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, long long _n)
__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, unsigned long long _n)
__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

#if 0
DCLCAPI inline OutputStream& operator << (OutputStream& _out, int32_t _n)
__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, uint32_t _n)
__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, int64_t _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, uint64_t _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}
#endif

DCLCAPI inline OutputStream& operator << (OutputStream& _out, float _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, double _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

DCLCAPI inline OutputStream& operator << (OutputStream& _out, long double _n)
		__DCL_THROWS1(IOException*)
{
	return _out.write(&_n, sizeof(_n));
}

__DCL_END_NAMESPACE

#endif	// __DCL_OUTPUT_STREAM_H__
