#ifndef __DCL_OUTPUT_STREAM_WRITER_H__
#define __DCL_OUTPUT_STREAM_WRITER_H__		20080525

#ifndef __DCL_WRITER_H__
#include <dcl/Writer.h>
#endif
#ifndef __DCL_OUTPUT_STREAM_H__
#include <dcl/OutputStream.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * wchar_t 스트림과 바이트스트림 사이의 다리역할을 한다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		OutputStream
 * @see		CharsetEncoder
 */

class CharsetEncoder;

class DCLCAPI OutputStreamWriter : public Writer
{
	DECLARE_CLASSINFO(OutputStreamWriter)
protected:
	/**
	 * 파생클래스를 위한 생성자이다.
	 */
	OutputStreamWriter();

public:
	/**
	 * 객체의 구성에 대하여 간략한 요약을 리턴한다.
	 */
	virtual String toString() const;

	/**
	 * 참조된 스트림과 엔코더로 객체를 구성한다.
	 * _output과 _encoder는 객체의 생면주기동안 유효해야 하며,
	 * _output은 {@link #close()}에서 close하지 않는다.
	 *
	 * @param _output
	 *		A OutputStream
	 * @param _decoder
	 *		A CharsetEncoder
	 */	
	OutputStreamWriter(
		OutputStream&		__noclose__ _output,
		CharsetEncoder&	_encoder
		);

	/**
	 * 넘겨받은 스트림과 디코더로 객체를 구성한다.
	 * {@link #close()}에서 _pOutput의 close()가 호출되고 _pOutput과 _pEncoder는 파괴된다.
	 *
	 * @param _pOutput
	 *		A OutputStream
	 * @param _pEncoder
	 *		NULL이면 LocaleEncoder를 사용한다.
	 */	
	OutputStreamWriter(
		OutputStream*		__destroy__ _pOutput,				// new OutputStream
		CharsetEncoder*	__destroy__ _pEncoder = NULL	// new CharsetEncoder
		);

	/**
	 * 객체의 파괴를 수행한다.
	 * close하지 않았으면 {@link #close()}하며 예외가 발생하면 무시한다.
	 */
	virtual ~OutputStreamWriter();

	/**
	 * 객체를 닫는다. 넘겨받은 OutputStream과 CharsetEncoder는 파괴된다.
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 * 사용하고 있는 OutputStream의 flush를 호출한다.
	 */
	virtual void flush()
			__DCL_THROWS1(IOException*);

	/**
	 * 텍스트를 출력한다.
	 *
	 * @param _buf
	 *		버퍼
	 * @param _n
	 *		버퍼의 크기가 _n개의 wchar_t 문자 
	 * @return
	 *		Writer&
	 */
	virtual Writer& write(const wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

protected:
	OutputStream*		__output;
	CharsetEncoder*		__encoder;
	bool				__closeDestroy;
};

__DCL_END_NAMESPACE

#endif		// __DCL_OUTPUT_STREAM_WRITER_H__
