#ifndef __DCL_POLL_ABLE_H__
#define __DCL_POLL_ABLE_H__		20110426

#ifndef __DCL_FILE_H__
#include <dcl/File.h>
#endif

__DCL_BEGIN_NAMESPACE

class PollThread;

/**
 * Non-Blocking 입출력 파일의 기본 인터페이스를 정의한다.
 *
 * @see PollThread
 * @see SerialPort
 * @see Socket
 */

class DCLCAPI PollAble : public File
{
	DECLARE_CLASSINFO(PollAble)
protected:
	PollAble();
	/**
	 * {@link SerialPollThread}에의해 감시되다가 이벤트가 발생되었을 때 호출된다.
	 * <p>false를 반환하거나, 예외가 발생하면 PollThread는 PollAble를 제거한다.</p>
	 * 
	 */
	virtual bool onEvent(short _revents, PollThread* _pPollThread)
		__DCL_THROWS1(IOException*) = 0;

	/**
	 * notifiable events, 이것은 PollThread에 의해 설정된다.
	 */
	short	__events;

	friend class PollThread;
};

__DCL_END_NAMESPACE

#endif		// __DCL_POLL_ABLE_H__
