#ifndef __DCL_READER_H__
#define __DCL_READER_H__	20080606

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * wchar_t 스트림을 읽기 위한 최상위 추상클래스이다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		Writer
 */
class DCLCAPI Reader : public Object
{
	DECLARE_CLASSINFO(Reader)
public:
	/**
	 * 객체를 닫는다
	 * <p>이것의 기본 구현은 아무런 행위가 없다. 파생클래스는 스트림을 닫기위해 이것을 override한다.</p>
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 *	_n개의 wchar_t 문자를 읽으며, 1번이상 블록되지 않는다.
	 *
	 *	@return is 0 then EOF
	 */
	virtual size_t read(wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*) = 0;
};

__DCL_END_NAMESPACE

#endif	// __DCL_READER_H__
