#ifndef __DCL_REGEX_H__
#define	__DCL_REGEX_H__		20041119

#ifndef __DCL_CONFIG_H__
#include <dcl/Config.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

#include <dcl/_regex.h>

__DCL_BEGIN_NAMESPACE

class StringArray;

class DCLCAPI RegexException : public Exception
{
	DECLARE_CLASSINFO(RegexException)
public:
	RegexException(const char* _name, const char* _what);
	virtual String toString() const;

protected:
	String	__message;
};

class DCLCAPI Regex
{
public:
	enum CompileFlags {
		ICASE		= regex_icase,
		NOSUBS		= regex_nosubs,
		NEWLINE		= regex_newline
	};

	enum MatchFlags {
		NOTBOL		= regex_not_bol,
		NOTEOL		= regex_not_eol
	};

	class DCLCAPI MatchResults
	{
	private:
		match_result*	__results;
		size_t	__size;
		void attach(match_result* _results, size_t _size);
		friend class Regex;
	public:
		MatchResults();
		~MatchResults();
		const match_result& operator [] (size_t _index) const
			__DCL_THROWS1(InvalidIndexException*);
		size_t size() const { return __size; }
	};

private:
	void*	__handle;
public:
	Regex();
	~Regex();

	Regex(const wchar_t* _pattern, size_t _n, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	void compile(const wchar_t* _pattern, size_t _n, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	bool search(const wchar_t* _begin, const wchar_t* _end, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	bool search(const wchar_t* _begin, const wchar_t* _end, MatchResults& _results, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	bool match(const wchar_t* _begin, const wchar_t* _end, unsigned int _flags)
		__DCL_THROWS1(RegexException*);

	bool match(const wchar_t* _begin, const wchar_t* _end, MatchResults& _results, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);


	Regex(const String& _pattern, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	void compile(const String& _pattern, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	bool search(const String& _string, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	bool search(const String& _string, MatchResults& _results, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	bool match(const String& _string, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);
	
	bool match(const String& _string, MatchResults& _results, unsigned int _flags = 0)
		__DCL_THROWS1(RegexException*);

	String replace(
			const String& _string,
			const String& _replacement,
			size_t _limit = (size_t)-1
			) __DCL_THROWS1(RegexException*);

	size_t split(
			const wchar_t* _begin, const wchar_t* _end,
			StringArray& _results,
			size_t _limit = (size_t)-1	// unlimited
			) __DCL_THROWS1(RegexException*);

	size_t split(
			const String& _string,
			StringArray& _results,
			size_t _limit = (size_t)-1		//  unlimited
			) __DCL_THROWS1(RegexException*);

	static bool test(
			const wchar_t* _regex,
			const wchar_t* _string,
			bool _icase = false
			) __DCL_THROWS1(RegexException*);

	static bool test(
			const char* _regex,
			const char* _string,
			bool _icase = false
			) __DCL_THROWS1(RegexException*);
};

inline void Regex::compile(const String& _pattern, unsigned int _flags) // = 0)
		__DCL_THROWS1(RegexException*)
{
	compile(_pattern.data(), _pattern.length(), _flags);
}

inline bool Regex::search(const String& _string, unsigned int _flags) // = 0)
		__DCL_THROWS1(RegexException*)
{
	return search(_string.data(), _string.data() + _string.length(), _flags);
}

inline bool Regex::search(const String& _string, MatchResults& _results, unsigned int _flags) // = 0)
		__DCL_THROWS1(RegexException*)
{
	return search(_string.data(), _string.data() + _string.length(), _results, _flags);
}

inline bool Regex::match(const String& _string, unsigned int _flags) // = 0)
		__DCL_THROWS1(RegexException*)
{
	return match(_string.data(), _string.data() + _string.length(), _flags);
}
	
inline bool Regex::match(const String& _string, MatchResults& _results, unsigned int _flags) // = 0)
		__DCL_THROWS1(RegexException*)
{
	return match(_string.data(), _string.data() + _string.length(), _results, _flags);
}

inline size_t Regex::split(
			const String& _string,
			StringArray& _results,
			size_t _limit	// = (size_t)-1		//  unlimited
			) __DCL_THROWS1(RegexException*)
{
	return split(_string.data(), _string.data() + _string.length(), _results, _limit);
}

__DCL_END_NAMESPACE

#endif	// __DCL_REGEX_H__
