#ifndef __DCL_REGISTRY_H__
#define __DCL_REGISTRY_H__		20080607

#ifndef __DCL_CONFIG_H__
#include <dcl/_Config.h>
#endif

#include <winreg.h>

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

#if __DCL_DEBUG
static const char_t __szWinRegistry_h__[] = __T("dcl/Registry.h");
#undef __THIS_FILE__
#define __THIS_FILE__ __szWinRegistry_h__
#endif

__DCL_BEGIN_NAMESPACE

typedef struct _REGISTRY_DATAINFO
{
	DWORD	dwDataType;
	DWORD	dwDataSize;
} REGISTRY_DATAINFO;

class DCLCAPI Registry : public Object
{
	DECLARE_CLASSINFO(Registry)
public:
	Registry(HKEY hParentKey);

	Registry(
		HKEY hParentKey,
		const String& strKey,
		REGSAM samDesired = KEY_READ
		) __DCL_THROWS1(IOException*);

	virtual ~Registry();

	void create(const String& strKey, REGSAM samDesired = KEY_ALL_ACCESS)
			__DCL_THROWS1(IOException*);

	void open(const String& strKey, REGSAM samDesired = KEY_ALL_ACCESS)
			__DCL_THROWS1(IOException*);

	void close()
			__DCL_THROWS1(IOException*);


	String getString(const String& strName)
			__DCL_THROWS1(IOException*);

	int getInteger(const String& strName)
			__DCL_THROWS1(IOException*);

	void setValue(const String& strName, const String& strValue)
			__DCL_THROWS1(IOException*);

	void setValue(const String& strName, int nValue);
			__DCL_THROWS1(IOException*);

	HKEY parentKey() const;
	HKEY key() const;
	REGSAM sam() const;
	const String& keyName() const;
	bool opened() const;
	bool existsValue(const String& strName);
	bool existsSubKey(const String& strKey) const;
	static bool existsKey(const String& strKeyName, HKEY hParentKey);
	
protected:
	HKEY	m_hParentKey;
	HKEY	m_hKey;
	REGSAM	m_samDesired;
	String	m_strKey;
	
	LONG getDataInfo(const String& strName, REGISTRY_DATAINFO& info);
};


inline HKEY Registry::parentKey() const
{ 
	return m_hParentKey; 
}
	
inline HKEY Registry::key() const
{ 
	__DCL_ASSERT(opened()); 
	return  m_hKey; 
}

inline REGSAM Registry::sam() const
{
	__DCL_ASSERT(opened());
	return m_samDesired;
}

inline const String& Registry::keyName() const 
{
	__DCL_ASSERT(opened());
	return m_strKey; 
}

inline bool Registry::opened() const
{
	return m_hKey != NULL; 
}

inline bool Registry::existsSubKey(const String& strKey) const
{
	return Registry::existsKey(strKey, m_hKey);
}


__DCL_END_NAMESPACE

#if __DCL_DEBUG
#undef __THIS_FILE__
#define __THIS_FILE__	__T(__FILE__)
#endif

#endif	// __DCL_REGISTRY_H__
