#ifndef __DCL_SQL_H__
#define __DCL_SQL_H__	20050322

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif

#include <dcl/SQLCore.h>
#include <dcl/SQLDriver.h>

#ifndef __DCL_NUMERIC_H__
#include <dcl/Numeric.h>
#endif
#ifndef __DCL_DATE_TIME_H__
#include <dcl/DateTime.h>
#endif
#ifndef __DCL_INPUT_STREAM_H__
#include <dcl/InputStream.h>
#endif
#ifndef __DCL_OUTPUT_STREAM_H__
#include <dcl/OutputStream.h>
#endif

#ifndef __DCL_THREAD_H__
#include <dcl/Thread.h>
#endif
#ifndef __DCL_ARRAY_H__
#include <dcl/Array.h>
#endif
#ifndef __DCL_LIST_H__
#include <dcl/List.h>
#endif
#ifndef __DCL_HASH_MAP_H__
#include <dcl/HashMap.h>
#endif

__DCL_BEGIN_NAMESPACE

class SQLField;
class SQLFields;
class SQLParam;
class SQLParams;
class SQLQuery;
class SQLConnection;
class SQLConnectionPool;

class DCLCAPI SQLField : public Object
{
	DECLARE_CLASSINFO(SQLField)
public:
	SQL::Field* handle() const;
	const String& name() const ;

	SQL::DataType dataType() const;
	const wchar_t* dataTypeName() const;
	const wchar_t* serverDataTypeName() const;

	short precision() const;
	short scale() const;

	bool isNull() const;

	size_t getDataSize(
			bool _maxSize = false
			) __DCL_THROWS1(SQLException*);

	void getData(
			void*			_pv,			// buffer
			size_t*			_pn,			// sizeof *_pv
			SQL::DataType	_dataType	// buffer data type
			) __DCL_THROWS1(SQLException*);

	// helper functions
	size_t dataSize() __DCL_THROWS1(SQLException*);
	size_t dataSizeMax() __DCL_THROWS1(SQLException*);

	void getValue(int32_t& _r) __DCL_THROWS1(SQLException*);
	void getValue(uint32_t& _r) __DCL_THROWS1(SQLException*);
	void getValue(int64_t& _r) __DCL_THROWS1(SQLException*);
	void getValue(uint64_t& _r) __DCL_THROWS1(SQLException*);
	void getValue(float& _r) __DCL_THROWS1(SQLException*);
	void getValue(double& _r) __DCL_THROWS1(SQLException*);
	void getValue(SQL::Date& _r) __DCL_THROWS1(SQLException*);
	void getValue(SQL::Time& _r) __DCL_THROWS1(SQLException*);
	void getValue(SQL::TimeStamp& _r) __DCL_THROWS1(SQLException*);
	void getValue(SQL::Interval& _r) __DCL_THROWS1(SQLException*);
	void getValue(String& _r) __DCL_THROWS2(SQLException*, CharsetConvertException*);
	void getValue(
			ByteString& _r,
			SQL::DataType _dataType = SQL::typeBinary
			) __DCL_THROWS1(SQLException*);

	void getValue(
			OutputStream&	_r,
			size_t			_n = (size_t)-1
			) __DCL_THROWS1(SQLException*);

	bool asBoolean() __DCL_THROWS1(SQLException*);
	int asInteger() __DCL_THROWS1(SQLException*);
	int32_t asInt32() __DCL_THROWS1(SQLException*);
	int64_t asInt64() __DCL_THROWS1(SQLException*);
	float asSingle() __DCL_THROWS1(SQLException*);
	double asDouble() __DCL_THROWS1(SQLException*);

	Date asDate() __DCL_THROWS1(SQLException*);
	Time asTime() __DCL_THROWS1(SQLException*);
	DateTime asDateTime() __DCL_THROWS1(SQLException*);
	Interval asInterval() __DCL_THROWS1(SQLException*);

	String asString() __DCL_THROWS2(SQLException*, CharsetConvertException*);
	// Formatted String
	String asStringF(
			const wchar_t* _format = NULL
			) __DCL_THROWS2(SQLException*, CharsetConvertException*);
	
protected:
	SQL::Field*	__handle;
	SQLQuery*	__query;
protected:
//	SQLField(SQL::Field* hField);
	SQLField();
	virtual ~SQLField();

	friend class SQLFields;
};

class DCLCAPI SQLParam : public SQLField
{
	DECLARE_CLASSINFO(SQLParam)
public:
	void setNull();
	void setData(
			_CONST void*	_pv,		// data, IN
			size_t			_n,			// sizeof *_pv
			SQL::DataType	_dataType,	// typeof *_pv
			SQL::DataType	_assignType	// assign to server type
			) __DCL_THROWS1(SQLException*);

	// out param support
	void setDataType(
			SQL::DataType	_dataType
			) __DCL_THROWS1(SQLException*);

	// helper functions
#if defined(_MSC_VER) && _MSC_VER <= 1200
	void setValue(int _value) __DCL_THROWS1(SQLException*);
	void setValue(unsigned int _value) __DCL_THROWS1(SQLException*);
#endif
	void setValue(int32_t _value) __DCL_THROWS1(SQLException*);
	void setValue(uint32_t _value) __DCL_THROWS1(SQLException*);
	void setValue(int64_t _value) __DCL_THROWS1(SQLException*);
	void setValue(uint64_t _value) __DCL_THROWS1(SQLException*);
	void setValue(float _value) __DCL_THROWS1(SQLException*);
	void setValue(double _value) __DCL_THROWS1(SQLException*);
	void setValue(
			const Decimal& _value
			) __DCL_THROWS2(SQLException*, CharsetConvertException*);

	void setValue(Date _value) __DCL_THROWS1(SQLException*);
	void setValue(
			Time _value,
			int16_t _tzMinute = INT16_MIN
			) __DCL_THROWS1(SQLException*);
	void setValue(
			DateTime _value,
			int16_t _tzMinute = INT16_MIN
			) __DCL_THROWS1(SQLException*);

	void setValue(
			Interval _value,
			SQL::DataType _assignType = SQL::typeIntervalDs
			) __DCL_THROWS1(SQLException*);

	void setValue(
			const String& _value,
			SQL::DataType _assignType = SQL::typeText
			) __DCL_THROWS2(SQLException*, CharsetConvertException*);

	void setValue(
				const wchar_t* _p, size_t _n,
				SQL::DataType _assignType = SQL::typeText
			) __DCL_THROWS2(SQLException*, CharsetConvertException*);

	void setValue(
			const ByteString& _value,
			SQL::DataType _assignType = SQL::typeBinary
			) __DCL_THROWS1(SQLException*);

	void setValue(
			_CONST char* _p, size_t _n,
			SQL::DataType _assignType = SQL::typeBinary
			) __DCL_THROWS1(SQLException*);

	void setValue(
			_CONST InputStream* _input, size_t _n = (size_t)-1,
			SQL::DataType _assignType = SQL::typeLongBinary
			) __DCL_THROWS1(SQLException*);

protected:
	ByteString		__bytesValue;		// for String, Decimal

protected:
//	SQLParam(SQL::Param* hParam);
	SQLParam();
	virtual ~SQLParam();

	friend class SQLParams;
};

class DCLCAPI SQLFields : public Object
{
	DECLARE_CLASSINFO(SQLFields)
protected:
	SQLField*			__fields;
	size_t				__count;
	StringToPointerMap	__fieldMap;	

protected:
	SQLFields();
	virtual ~SQLFields();

	void clear();
	void initialize(SQLQuery* _query);
	friend class SQLQuery;

public:
	_CONST SQLField& at(size_t _index) const;
	_CONST SQLField& byName(
			const wchar_t* _name
			) _CONST __DCL_THROWS1(InvalidIndexException*);

	_CONST SQLField& operator[](size_t _index) const ;
	size_t count() const;
	bool isEmpty() const;
};

class DCLCAPI SQLParams : public Object
{
	DECLARE_CLASSINFO(SQLParams)
protected:
	SQLParam*			__params;
	size_t				__count;
	StringToPointerMap	__paramMap;

protected:
	SQLParams();
	virtual ~SQLParams();

	void clear();
	void initialize(SQLQuery* _query, const StringArray _names);
	friend class SQLQuery;

public:
	SQLParam& at(size_t _index) const;
	SQLParam& byName(
		const wchar_t* _name
		) _CONST __DCL_THROWS1(InvalidIndexException*);

	SQLParam& operator[](size_t _index) const;
	size_t count() const;
	bool isEmpty() const;
};

class DCLCAPI SQLQuery : public Object
{
	DECLARE_CLASSINFO(SQLQuery)
protected:
	void initialize(SQLConnection* _conn) __DCL_THROWS1(SQLException*);

public:
	SQLQuery(SQLConnection* _conn) __DCL_THROWS1(SQLException*);
	SQLQuery(SQLConnection& _conn) __DCL_THROWS1(SQLException*);
	virtual ~SQLQuery();

	void prepare(
			const String& _sql
			) __DCL_THROWS2(SQLException*, CharsetConvertException*);

	void execute() __DCL_THROWS1(SQLException*);

	void execute(
			const String& _sql
			) __DCL_THROWS2(SQLException*, CharsetConvertException*);

	void fetch() __DCL_THROWS1(SQLException*);
	bool nextResult() __DCL_THROWS1(SQLException*);
	bool eof() const;
	int64_t affectedRows() const;
	_CONST SQLFields& fields() _CONST;
	_CONST SQLParams& params() _CONST;

	SQL::Query* handle() const;
	SQLConnection* connection() const;

protected:
	SQL::Query*		__handle;
	SQLConnection*	__connection;
	SQLFields		__fields;
	SQLParams		__params;

#if __DCL_DEBUG
	String			__sql;
#endif
};

class DCLCAPI SQLConnection : public Object
{
	DECLARE_CLASSINFO(SQLConnection)
protected:
	void initialize(SQLDriver* _driver);

public:
	SQLConnection(SQLDriver* _driver);
	SQLConnection(const String& _driverName)
			__DCL_THROWS1(SQLDriverException*);
	virtual ~SQLConnection();

	// Operations
	// "USER=aUser; PASSWORD=aPW; DATABASE=aDB; SERVER=aHost"
	void open(const String& _connString)
		__DCL_THROWS2(SQLException*, CharsetConvertException*);
	void close() __DCL_THROWS1(SQLException*);
	void execute(const String& _sql)
		__DCL_THROWS2(SQLException*, CharsetConvertException*);
	void startTrans() __DCL_THROWS1(SQLException*);
	void commitTrans() __DCL_THROWS1(SQLException*);
	void rollbackTrans() __DCL_THROWS1(SQLException*);

	String getServerInfo()
		__DCL_THROWS2(SQLException*, CharsetConvertException*);

	bool canTransact() const;

	// Properties
	SQL::Connection* handle() const;
	SQLDriver* driver() const;
	bool connected() const;
	bool inTransaction() const;

protected:
	SQL::Connection*	__handle;
	SQLDriver*		__driver;
	bool			__connected;
};

class DCLCAPI SQLConnectionPool : public Object
{
	DECLARE_CLASSINFO(SQLConnectionPool)
public:
	SQLConnectionPool(
			const String& _connString, 
			const String& _driverName
			) __DCL_THROWS1(SQLDriverException*);

	virtual ~SQLConnectionPool();

	// NULL reach __allMax
	SQLConnection* getConnection() __DCL_THROWS1(SQLException*);
	void release(SQLConnection* _conn);

	bool setMaxCount(size_t _idleMax, size_t _allMax);

	size_t count() const;

	size_t idleCount() const;

	void clear(unsigned _waitSeconds);

protected:
	SQLDriver*		__sqlDriver;
	String			__connString;

	PointerList		__idleConns;
	PointerArray	__allConns;

	Thread::Mutex	__lock;

	size_t			__idleMax;
	size_t			__allMax;
};

// exception support for addtional members
class DCLCAPI SQLException : public Exception
{
	DECLARE_CLASSINFO(SQLException)
public:
	enum AsErrorCode
	{
		// asInt32, asInt64, asSingle, ... 변환 에러
		eInvalidCast,
		eOutOfRange
	};
	String		__message;

protected:
	String getServerMessage(SQL::Connection* _connHandle);

public:
	SQLException(SQLConnection* _conn);
	SQLException(SQLConnection* _conn, const String& _message);
	SQLException(SQLQuery* _query);
	SQLException(SQLQuery* _query, const String& _message);
	SQLException(SQLField* _field);
	SQLException(
			SQLField* _field,
			const wchar_t* _cast,
			AsErrorCode errorCode
			);
	SQLException(
			SQLField* _field,
			const wchar_t* _cast,
			Exception* _cause
			);
	SQLException(SQLParam* _param);

	virtual String toString() const;
};

#include <dcl/SQL.inl>

__DCL_END_NAMESPACE

#endif	// __DCL_SQL_H__
