#ifndef __DCL_SQL_H__
	#error "Never use <dcl/core/SQL.inl> directly; include <dcl/core/SQL.h> instead."
#endif
#ifndef __DCL_SQL_INL__
#define __DCL_SQL_INL__

#if __DCL_DEBUG
static const wchar_t* __pszSQL_inl__ = __T("dcl/SQL.inl");
#undef __THIS_FILE__
#define __THIS_FILE__ __pszSQL_inl__
#endif

inline SQL::Field* SQLField::handle() const
{
	return __handle;
}

inline const wchar_t* SQLField::dataTypeName() const
{
	return SQL::dataTypeName(dataType());
}

inline size_t SQLField::dataSize() __DCL_THROWS1(SQLException*)
{
	return getDataSize(false);
}

inline size_t SQLField::dataSizeMax() __DCL_THROWS1(SQLException*)
{
	return getDataSize(true);
}

inline int SQLField::asInteger() __DCL_THROWS1(SQLException*)
{

	switch (sizeof(int)) {
		case 4 : return asInt32();
		case 8 : return (int)asInt64();
		default : {
			__DCL_ASSERT(false);
		}
	}
	return 0;	// not reached
}

#if defined(_MSC_VER) && _MSC_VER <= 1200
inline void SQLParam::setValue(int value) __DCL_THROWS1(SQLException*)
{
	switch (sizeof(int)) {
		case 4 :
			setValue((int32_t)value);
			break;
		case 8 :
			setValue((int64_t)value);
			break;
		default : {
			__DCL_ASSERT(false);
		}
	}
}

inline void SQLParam::setValue(unsigned int value) __DCL_THROWS1(SQLException*)
{
	switch (sizeof(unsigned int)) {
		case 4 :
			setValue((uint32_t)value);
			break;
		case 8 :
			setValue((uint64_t)value);
			break;
		default : {
			__DCL_ASSERT(false);
		}
	}
}
#endif

/////// SQLFields /////////
inline _CONST SQLField& SQLFields::at(size_t _index) const
{
	__DCL_ASSERT_PARAM(_index >= 0);
	__DCL_ASSERT_PARAM(_index < __count);
	return __fields[_index];
}

inline _CONST SQLField& SQLFields::operator[](size_t _index) const
{
	__DCL_ASSERT_PARAM(_index >= 0);
	__DCL_ASSERT_PARAM(_index < __count);
	return __fields[_index];
}

inline size_t SQLFields::count() const
{
	return __count;
}

inline bool SQLFields::isEmpty() const
{
	return __count == 0;
}

////// _DBBinds //////////
inline SQLParam& SQLParams::at(size_t _index) const
{
	__DCL_ASSERT_PARAM(_index >= 0);
	__DCL_ASSERT_PARAM(_index < __count);
	return __params[_index];
}

inline SQLParam& SQLParams::operator[](size_t _index) const
{
	__DCL_ASSERT_PARAM(_index >= 0);
	__DCL_ASSERT_PARAM(_index < __count);
	return __params[_index];
}

inline size_t SQLParams::count() const
{
	return __count;
}

inline bool SQLParams::isEmpty() const
{
	return __count == 0;
}

// SQLQuery
inline bool SQLQuery::eof() const
{
	return __handle->eof();
}

inline int64_t SQLQuery::affectedRows() const
{
	return __handle->affectedRows();
}

inline _CONST SQLFields& SQLQuery::fields() _CONST
{
	return __fields;
}

inline _CONST SQLParams& SQLQuery::params() _CONST
{
	return __params;
}

inline SQL::Query* SQLQuery::handle() const
{
	return __handle;
}

inline SQLConnection* SQLQuery::connection() const
{
	return __connection;
}

// SQLConnection
inline SQL::Connection* SQLConnection::handle() const
{
	return __handle;
}

inline SQLDriver* SQLConnection::driver() const
{
	return __driver;
}

inline bool SQLConnection::connected() const
{
	return __connected;
}

// SQLConnectionPool
inline size_t SQLConnectionPool::count() const
{
	return __allConns.size();
}

inline size_t SQLConnectionPool::idleCount() const
{
	return __idleConns.size();
}

#if __DCL_DEBUG
#undef __THIS_FILE__
#define __THIS_FILE__	__T(__FILE__)
#endif

#endif	// __DCL_SQL_INL__
