#ifndef __DCL_SQLCORE_H__
	#error "Never use <dcl/SQLCore.inl> directly; include <dcl/core/SQLCore.h> instead."
#endif
#ifndef __DCL_SQLCORE_INL__
#define __DCL_SQLCORE_INL__

///////////// SQL::Field /////////////

inline const String& SQL::Field::name() const
{
	return __name;
}

inline SQL::DataType SQL::Field::dataType() const
{ 
	return __dataType; 
}

inline short SQL::Field::precision() const
{
	return __precision;
}

inline short SQL::Field::scale() const
{
	return __scale;
}

inline SQL::Connection* SQL::Field::connection() const
{ 
	return __queryHandle->connection(); 
}

///////////// SQL::Query /////////////

inline bool SQL::Query::eof() const
{ 
	return __eof; 
}

inline int64_t SQL::Query::affectedRows() const 
{ 
	return __affectedRows;
}

inline size_t SQL::Query::fieldCount() const
{ 
	return __fieldCount;
}

inline size_t SQL::Query::paramCount() const
{ 
	return __paramCount;
}

inline wchar_t SQL::Query::placeholder() const
{
	return __placeholder;
}

inline SQL::Connection* SQL::Query::connection() const 
{ 
	return __connHandle;
}

inline bool SQL::Query::inState(unsigned int _state) const 
{
	return (__states & _state) == _state;
}

///////////// SQL::Connection /////////////
inline SQL::Error SQL::Connection::errorCode() const 
{ 
	return __errorCode; 
}

#if __DCL_DEBUG
inline const wchar_t* SQL::Connection::errorFileName() const
{
	return __errorFileName;
}

inline int SQL::Connection::errorLine() const
{
	return __errorLine;
}
#endif

inline bool SQL::Connection::canTransact() const 
{ 
	return __canTransact; 
}

inline const wchar_t* SQL::Connection::serverTitle() const
{ 
	return __serverTitle; 
}

inline bool SQL::Connection::inState(unsigned int _state) const 
{
	return (__states & _state) == _state;
}

#endif	// __DCL_SQLCORE_INL__
