
#ifndef __DCL_SQLDRIVER_H__
#define __DCL_SQLDRIVER_H__	20050206

#ifndef __DCL_DLL_H__
#include <dcl/Dll.h>
#endif
#ifndef __DCL_INIFILE_H__
#include <dcl/IniFile.h>
#endif

#ifndef __DCL_SQLCORE_H__
#include <dcl/SQLCore.h>
#endif

__DCL_BEGIN_NAMESPACE

// Database Driver managements
class SQLDriver;
class DCLCAPI SQLDriverException : public Exception
{
	DECLARE_CLASSINFO(SQLDriverException)
public:
	enum ErrorCode
	{
		eInvalidDriverModule,	// DCLDynamicEntryPoint가 유효하지 않다.
		eInvalidVersion,		// 유효하지 않은 DCL_SQL_VERSION 이다.
		eInitializeFail,		// 모듈초기화 callback 실패
		eCleanupFail			// cleanup callback fail
	};

	String		__name;
	ErrorCode	__errorCode;
	String		__driverSummary;
public:
	SQLDriverException(const String& _name, Exception* _cause);
	SQLDriverException(const String& _name, ErrorCode _errorCode);
	SQLDriverException(const String& _name, ErrorCode _errorCode,
					const String& _driverSummary);

	virtual String toString() const;
};

class DCLCAPI SQLDriver : public Dll
{
	DECLARE_CLASSINFO(SQLDriver)
private:
	long	__refCount;

public:
	long refCount() const	{ return __refCount; }
	long addRef();		// new incremented __refCount
	long release();		// new decremented __refCount
public:
	SQLDriver(const String& _name)
		__DCL_THROWS1(SQLDriverException*);

	virtual ~SQLDriver();

	void open(const String& _name)
		__DCL_THROWS1(SQLDriverException*);

	void close()
		__DCL_THROWS1(SQLDriverException*);

	// properties
	const String& driverName() const { return __driverName; };
	String getDriverSummary() const;

	SQL::Connection* createConnection();
	void destroyConnection(SQL::Connection* pConnection);

protected:
	SQL::DRIVER_MODULE*		__pModuleEntryPoint;
	String					__driverName;

public:
	static SQLDriver* getDriver(const String& _name)
			__DCL_THROWS1(SQLDriverException*);

	static void closeDriver(SQLDriver* _pSQLDriver)
			__DCL_THROWS1(SQLDriverException*);
};

__DCL_END_NAMESPACE

#endif	// __DCL_SQLDRIVER_H__
