#ifndef __DCL_SSL_SOCKET_H__
#define __DCL_SSL_SOCKET_H__		20110923

#ifndef __DCL_CONFIG_H__
#include <dcl/Config.h>
#endif

#if __DCL_USE_OPENSSL
	#include <openssl/ssl.h>
#elif __DCL_USE_SCHANNEL
	#define SECURITY_WIN32
	#include <sspi.h>
	#include <schnlsp.h>
	#ifdef _MSC_VER
		#pragma comment(lib, "secur32.lib")
	#endif
#endif

#ifndef __DCL_SOCKET_H__
#include <dcl/Socket.h>
#endif

__DCL_BEGIN_NAMESPACE

class DCLCAPI SSLException : public Exception
{
	DECLARE_CLASSINFO(SSLException)

public:
	SSLException(Exception* _cause);
#if __DCL_USE_OPENSSL
	SSLException();
#elif __DCL_USE_SCHANNEL
	SSLException(SECURITY_STATUS ss);
#endif
	virtual String toString() const;
	
protected:
	String	__message;
};

/**
 * SSL/TLS 소켓에 대한 파일 인터페이스와 Non-Blocking 입출력을 제공한다.
 *
 * @see PollThread
 * @see SocketPollThread
 * @see openssl
 */
class DCLCAPI SSLSocket : public Socket
{
	DECLARE_CLASSINFO(SSLSocket)

public:

	virtual size_t available() const
			__DCL_THROWS1(IOException*);
#if 0

	virtual size_t read(void* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	virtual size_t write(const void* _buf, size_t _n)
			__DCL_THROWS1(IOException*);
	/**
	 * Listen 소켓 객체에 주소를 설정한다.
	 *
	 * <p>bind()호출 전에 create()를 호출하지 않았으면,
	 * _my_addr.sa_family, _type, _protocol을 사용하여 소켓을 생성한다.
	 *
	 * @param	_reuse
	 *		setsockopt를 사용하여 리슨소켓을 재사용하도록 설정한다.
	 */
	void bind(const Addr& _my_addr,
		int _type = SOCK_STREAM, int _protocol = 0,	bool _reuse = true
		) __DCL_THROWS1(IOException*);

	void accept(SSLSocket& _r)
		__DCL_THROWS1(IOException*);

	void connect(const Addr& _serv_addr)
		__DCL_THROWS1(IOException*);
#endif

public:
	// API implements
	SSLSocket()
		__DCL_THROWS1(SSLException*);

	SSLSocket(const String& _addr, uint16_t _port)
		__DCL_THROWS2(IOException*, SSLException*);

	virtual ~SSLSocket();
		
	virtual void close()
		__DCL_THROWS1(IOException*);

#if 0
	void create(int _domain = AF_INET, int _type = SOCK_STREAM, int _protocol = 0)
		__DCL_THROWS1(IOException*);

	void setNonblock()
		__DCL_THROWS1(IOException*);

	void bind(const struct sockaddr* _my_addr, socklen_t _addrlen)
		__DCL_THROWS1(IOException*);

	void listen(unsigned _backlog = 5)
		__DCL_THROWS1(IOException*);

	void accept(SSLSocket& r, struct sockaddr* _addr, socklen_t* _addrlen)
		__DCL_THROWS1(IOException*);
#endif

	virtual void connect(const sockaddr* _serv_addr, socklen_t _addrlen)
		__DCL_THROWS1(IOException*);

	/**
	 * @return Non-Blocking 상태에서 0을 반환할 수 있다. 이 경우 다시 시도해야 한다.
	 */
	virtual size_t send(const void* _buf, size_t _n, int _flags = 0)
		__DCL_THROWS1(IOException*);

	/**
	 * @return Non-Blocking 상태에서 0을 반환할 수 있다. 이 경우 다시 시도해야 한다.
	 */
	virtual size_t recv(void* _buf, size_t _n, int _flags = 0)
		__DCL_THROWS1(IOException*);

	bool isPeerCertificateVerified() const;

	String getPeerCertificateCommonName() const;

protected:
#if __DCL_USE_OPENSSL
	SSL_CTX*		__ctx;
	SSL*			__ssl;		
#elif __DCL_USE_SCHANNEL
	CredHandle	__cred;
	CtxtHandle	__ctxt;
#endif

	void construct()
		__DCL_THROWS1(SSLException*);
};

__DCL_END_NAMESPACE

#endif		// __DCL_SSL_SOCKET_H__
