#ifndef __DCL_SERIAL_POLL_THREAD_H__
#define __DCL_SERIAL_POLL_THREAD_H__		20110224

#ifndef __DCL_POLL_THREAD_H__
#include <dcl/PollThread.h>
#endif

__DCL_BEGIN_NAMESPACE

#if __DCL_WINDOWS
class SerialPort;

/**
 * SerialPort에 대한 비동기 감시기능을 제공한다.
 * <p>UNIX에서는 poll을, Windows에서는 WaitForMultipleObject를 사용한다.
 * UNIX에서 이 클래스는 IoPollThread와 구현이 동일하다.
 * </p>
 *
 * @see SerialPort
 * @see PollThread
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 */
class DCLCAPI SerialPollThread : protected PollThread
{
	DECLARE_CLASSINFO(SerialPollThread)
public:
	SerialPollThread(const char_t* _name = NULL);
	virtual ~SerialPollThread();

	void start() __DCL_THROWS1(SysError*)
	{	Thread::start();	}
	int join()
	{	return Thread::join();	}
	bool started() const
	{	return Thread::started(); }
	unsigned long id() const
	{	return Thread::id();	}
	const String& name() const
	{ return Thread::name();	}

	/**
	 * 감시할 직렬포트를 추가한다.
	 * <p>_pPollAble은 SerialPort의 인스턴스이어야 한다.
	 * 추가중에 CreateEvent, SetCommMask가 사용되며 실패하면 IOException* 예외가 발생한다.
	 * PollAble::onEvent 내에서 이 메소드를 호출할 경우 반드시 이 예외를 처리해야 한다.
	 * 그렇지 않으면, 스레드 내에서 PollAble를 제거한다.<p>
	 *
	 * @param _events
	 *		Windows SDK SetCommMask를 참고하라.
	 * @return
	 *		스레드가 종료 중 이면 추가를 위한 큐삽입에 실패하고 false를 반환한다.
	 */
	virtual bool add(PollAble* _pPollAble, short _events)
		__DCL_THROWS1(IOException*);

	/**
	 * 감시하고 있는 직렬포트를 제거한다.
	 * @return
	 *		스레드가 종료 중 이면 제거를 위한 큐삽입에 실패하고 false를 반환한다.
	 */
	virtual bool remove(PollAble* _pPollAble);

	/**
	 * 스레드를 종료 플래그를 설정한다.
	 * <p>이것을 호출 한 후에는 Thread::join을 사용하여 스레드의 종료상태를 확인하여야 한다.</p>
	 */
	void terminate();

protected:
	virtual int run();

	HANDLE	__pollInterrupt;
};
#else
	typedef PollThread SerialPollThread;
#endif		// __DCL_WINDOWS

__DCL_END_NAMESPACE

#endif		// __DCL_SERIAL_POLL_THREAD_H__
