#ifndef __DCL_SOCKET_POLL_THREAD_H__
#define __DCL_SOCKET_POLL_THREAD_H__		20110224

#ifndef __DCL_POLL_THREAD_H__
#include <dcl/PollThread.h>
#endif

__DCL_BEGIN_NAMESPACE

#if __DCL_WINDOWS
class Socket;
/**
 * Non-Blocking 소켓을 위한 비동기 입출력 감시기능을 제공한다.
 * <p>UNIX에서의 PollThread와 동일한 기능을 한다.
 * WSAWaitForMultipleEvents를 사용하여 구현되어 있고, 최대 사용가능한 소켓의 개수는 63개이다.
 * WSAWaitForMultipleEvents는 최대 64개의 WSAEVENT를 처리할 수 있으나, 이 클래스의 구현에서
 * 1개는 WSAWaitForMultipleEvents의 인터럽트를 위하여 사용하고 있다.
 * 
 * @see PollThread
 * @see SerialPollThread
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 */
class DCLCAPI SocketPollThread : protected PollThread
{
	DECLARE_CLASSINFO(SocketPollThread)
public:
	SocketPollThread(const char_t* _name = NULL);
	virtual ~SocketPollThread();

	void start() __DCL_THROWS1(SysError*)
	{	Thread::start();	}
	int join()
	{	return Thread::join();	}
	bool started() const
	{	return Thread::started(); }
	unsigned long id() const
	{	return Thread::id();	}
	const String& name() const
	{ return Thread::name();	}

	/**
	 * 감시할 소켓을 추가한다.
	 * <p>_pPollAble은 Socket의 인스턴스이어야 한다.
	 * 추가중에 WSACreateEvent, WSAEventSelect가 사용되며 실패하면 IOException* 예외가 발생한다.
	 * PollAble::onEvent 내에서 이 메소드를 호출할 경우 예외를 처리해야 한다.
	 * 그렇지 않으면, 스레드 내에서 PollAble를 제거한다.<p>
	 *
	 * @param	_events
	 *			자세한 내용은 WSAEventSelect 를 참고한다.
	 * @return
	 *		스레드가 종료 중 이면 추가를 위한 큐삽입에 실패하고 false를 반환한다.
	 */
	virtual bool add(PollAble* _pPollAble, short _events)
		__DCL_THROWS1(IOException*);

	/**
	 * 감시하고 있는 소켓을 제거한다.
	 * @return
	 *		스레드가 종료 중 이면 제거를 위한 큐삽입에 실패하고 false를 반환한다.
	 */
	virtual bool remove(PollAble* _pPollAble);

	/**
	 * 스레드를 종료 상태가 되도록 설정한다.
	 * <p>이것을 호출 한 후에는 Thread::join을 사용하여 스레드의 종료상태를 확인하여야 한다.</p>
	 */
	void terminate();

protected:
	virtual int run();

	WSAEVENT	__pollInterrupt;;
};
#else
	typedef PollThread SocketPollThread;
#endif		// __DCL_WINDOWS

__DCL_END_NAMESPACE

#endif		// __DCL_SOCKET_POLL_THREAD_H__
