#ifndef __DCL_STRING_READER_H__
#define __DCL_STRING_READER_H__		20080606

#ifndef __DCL_READER_H__
#include <dcl/Reader.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * {@link String} 으로부터 wchar_t 단위의 텍스트를 읽는다.
 *
 * @author	Daejung Kim
 * @since	DCL Version 3.0
 *
 * @see		String
 * @see		BufferedReader
 */
class DCLCAPI StringReader : public Reader
{
	DECLARE_CLASSINFO(StringReader)
public:
	/**
	 * 스트림에 대한 간략한 요약을 반환한다.
	 */
	virtual String toString() const;

	/**
	 * String으로부터 객체를 구성한다.
	 */
	StringReader(const String& _str);

	/**
	 * 버퍼의 크기만큼 wchar_t 텍스트를 읽는다.
	 * @param _buf
	 *		버퍼
	 * @param _n
	 *		버퍼의 wchar_t의 개수
	 * @return
	 *		읽혀진 문자의 개수이다. 0이면 EOF이다.
	 */
	virtual size_t read(wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	/**
	 * 한줄을 읽는다. 각각의 줄은 CR, LF 또는 CRLF일 수 있따.
	 * @param _buf
	 *		반환할 줄 버퍼이다. CR, LF, CRLF는 포함하지 않는다.
	 * @return
	 *		false이면 EOF이다.
	 */
	virtual bool readLine(String& _buf)
			__DCL_THROWS1(IOException*);

private:
	String				__str;
	const wchar_t*		__begin;
	const wchar_t*		__end;
	bool				__endLine;
};

#if 0
inline bool StringReader::eof() const
{
	return m_pCur == m_pEnd;
}
#endif
__DCL_END_NAMESPACE

#endif	// __DCL_BUFFER_READER_H__

