#ifndef __DCL_TEXT_TEMPLATE_H__
#define __DCL_TEXT_TEMPLATE_H__		20060104

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_ARRAY_H__
#include <dcl/Array.h>
#endif
#ifndef __DCL_SQL_H__
#include <dcl/SQL.h>		// class SQLFields
#endif

/* sub block
<!-- BEGIN name -->
<!-- END name -->
*/

__DCL_BEGIN_NAMESPACE

class DCLCAPI TextTemplate : public Object
{
	DECLARE_CLASSINFO(TextTemplate)
public:
	virtual ~TextTemplate();
	TextTemplate();
	TextTemplate(const TextTemplate& _src);
	TextTemplate(const String& _text);

	TextTemplate& operator = (const TextTemplate& _src);

	void parse(const String& _text);

	// _name ==> _filename, insert sub template
	void parse(const String& _name, const String& _text);

	void clear();

	void reset();

	void erase(const char_t* _name);

	// RETURN : assigned count
	int assign(const char_t* _name, const String& _value);
	int assign(const char_t* _name, const TextTemplate& _template);
	int assign(const char_t* _name);
	int assign(const StringStringArray& _nameToValues);
	int assign(_CONST SQLFields& _fields, const String& _fieldIsNullValue);

	int append(const char_t* _name, const String& _value);
	int append(const char_t* _name, const TextTemplate& _template);
	int append(const char_t* _name);
	int append(const StringStringArray& _nameToValues);
	int append(_CONST SQLFields& _fields, const String& _fieldIsNullValue);

#ifdef __DCL_DEBUG
	void showEmptyName(bool _show, bool _withSubTemplate);
#endif
	void printTo(Writer& out) const
			__DCL_THROWS1(IOException*);

	// REF sub Template Object, _name이 없으면 비어있는 객체 리턴
	TextTemplate& operator [] (const String& _name);
	// _name이 있으면 객체의 주소, 없으면 NULL
	TextTemplate* atP(const String& _name) const;
	bool exists(const String& _name, bool bSubTemplate = true) const;

protected:
	// override members
	virtual String onSQLFieldValue(_CONST SQLField& _field, const String& _fieldIsNullValue);

protected:
	void*	__textList;
	void*	__subTemplateMap;
#ifdef __DCL_DEBUG
	bool	__showEmptyName;
#endif

	// sub 템플릿을 분할할하고 parseHelper를 호출하여
	// 분할된 블럭에서 sub 템플릿을 구성한다.
	// char_t* psz : parse는 regex를 사용한다. regexec는 NULL 종료
	// 문자열을 사용하기 때문에 parse 중간에 데이터를 NULL 종결 문자열로
	// 만들어서 처리한다.
	void parseHelper(const char_t* _begin, const char_t* _end);
	void parse(const char_t* _begin, const char_t* _end);

	int append(const char_t* _name, const String& _value, bool _clearExists);
	int append(const char_t* _name, const TextTemplate& _template, bool _clearExists);
	int append(const StringStringArray& _nameToValues, bool _clearExists);
	int append(_CONST SQLFields& _fields, const String& _fieldIsNullValue, bool _clearExists);
};

DCLCAPI inline Writer& operator << (Writer& out, TextTemplate& _template)
{
	_template.printTo(out);
	return out;
}

inline int TextTemplate::assign(const char_t* _name, const String& _value)
{
	return append(_name, _value, true);
}

inline int TextTemplate::assign(const char_t* _name, const TextTemplate& _template)
{
	return append(_name, _template, true);
}

inline int TextTemplate::assign(const char_t* _name)
{
	return append(_name, (*this)[_name], true);
}

inline int TextTemplate::assign(const StringStringArray& _nameToValues)
{
	return append(_nameToValues, true);
}

inline int TextTemplate::assign(_CONST SQLFields& _fields, const String& _fieldIsNullValue)
{
	return append(_fields, _fieldIsNullValue, true);
}

inline int TextTemplate::append(const char_t* _name, const String& _value)
{
	return append(_name, _value, false);
}

inline int TextTemplate::append(const char_t* _name, const TextTemplate& _template)
{
	return append(_name, _template, false);
}

inline int TextTemplate::append(const char_t* _name)
{
	return append(_name, (*this)[_name], false);
}

inline int TextTemplate::append(const StringStringArray& _nameToValues)
{
	return append(_nameToValues, false);
}

inline int TextTemplate::append(_CONST SQLFields& _fields, const String& _fieldIsNullValue)
{
	return append(_fields, _fieldIsNullValue, false);
}

__DCL_END_NAMESPACE

#endif	// __DCL_TEXT_TEMPLATE_H__
