#ifndef __DCL_TRANSFER_ENCODING_H__
#define __DCL_TRANSFER_ENCODING_H__		1

#ifndef __DCL_CONFIG_H__
#include <dcl/_Config.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif

/*
	References
		http://www.faqs.org/rfcs/rfc1521.html
		Multipurpose Internet Mail Extensions 
			(MIME) Part One:
			Format of Internet Message Bodies

		RFC 2045, 1590, 1522, 1521
*/

__DCL_BEGIN_NAMESPACE

// 5.1.   Quoted-Printable Content-Transfer-Encoding
class DCLCAPI QuotedPrintableEncoder
{
public:
	// convert 8bit string to quoted-printable string
	static ByteString encode(const ByteString& _str);
};

class DCLCAPI QuotedPrintableDecoder
{
public:
	// convert quoted-printable string to 8bit string
	static ByteString decode(const ByteString& _str);
};

// 5.2.   Base64 Content-Transfer-Encoding
class DCLCAPI Base64Encoder
{
public:
	// binary to base64 string
	static ByteString encode(const ByteString& _str);
};

class DCLCAPI Base64Decoder
{
	// base64 string to binary
	// RETURN s.cstr(), s.length()
	static ByteString decode(const ByteString& _str);
};

__DCL_END_NAMESPACE

#endif	// __DCL_TRANSFER_ENCODING_H__
