#ifndef __DCL_WRITER_H__
#define __DCL_WRITER_H__	20071008

#ifndef __DCL_OBJECT_H__
#include <dcl/Object.h>
#endif
#ifndef __DCL_EXCEPTION_H__
#include <dcl/Exception.h>
#endif
#ifndef __DCL_STRING_H__
#include <dcl/String.h>
#endif
#ifndef __DCL_OUTPUT_STREAM_H__		// for endl
#include <dcl/OutputStream.h>
#endif
#ifndef __DCL_NUMERIC_H__
#include <dcl/Numeric.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * wchar_t 스트림을 쓰기 위한 최상위 추상클래스이다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		Reader
 */
class DCLCAPI Writer : public Object
{
	DECLARE_CLASSINFO(Writer)
public:
	/**
	 * 스트림을 닫는다.
	 * <p>이것의 기본 구현은 아무런 행위가 없다. 파생클래스는 스트림을 닫기위해 이것을 override한다.</p>
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 * 스트림이 버퍼링을 한다면 이를 내보낸다.
	 * <p>이것의 기본 구현은 아무런 행위가 없다. 파생클래스는 스트림을 닫기위해 이것을 override한다.</p>
	 */
	virtual void flush()
			__DCL_THROWS1(IOException*);

	/**
	 * _n개의 wchar_t 문자를 쓴다(write)
	 * <p>파생클래스는 _n개의 wchar_t 문자를 write하는 것에 대하여 보장하도록 구현해야 한다.</p>
	 *
	 * @param _buf
	 *		버퍼
	 * @param _n
	 *		버퍼의 wchar_t 문자개수가 _n개
	 * @return
	 *		Writer&
	 */
	virtual Writer& write(const wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*) = 0;

	/**
	 * 형식화된 문자열을 출력한다.
	 * @param _format
	 *		포멧 문자열. %s는 %ls로 해석된다.
	 * @param _arglist
	 *		아귀먼트 리스트
	 * @return
	 *		출력된 총 wchar_t 문자의 개수를 반환한다.
	 */
	virtual int vprintf(const wchar_t* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

	/**
	 * 형식화된 문자열을 출력한다. 이 메소드는 내부적으로 vprintf를 호출한다.
	 */
	int printf(const wchar_t* _format, ...)
			__DCL_THROWS1(IOException*);
};

#if __DCL_DEBUG
static const wchar_t* __pszWriter_h__ = __T("dcl/Writer.h");
#undef __THIS_FILE__
#define __THIS_FILE__ __pszWriter_h__
#endif

DCLCAPI Writer& operator << (Writer& _writer, const __endl&)
		__DCL_THROWS1(IOException*);

DCLCAPI inline Writer& operator << (Writer& _writer, const wchar_t* _psz)
			__DCL_THROWS1(IOException*)
{
	__DCL_ASSERT(_psz != NULL);
	return _writer.write(_psz, String::length(_psz));
}

DCLCAPI inline Writer& operator << (Writer& _writer, const String& _str)
			__DCL_THROWS1(IOException*)
{
	return _writer.write(_str.data(), _str.length());
}

DCLCAPI inline Writer& operator << (Writer& _writer, const StringBuilder& _sb)
__DCL_THROWS1(IOException*)
{
	return _writer.write(_sb.data(), _sb.length());
}

DCLCAPI inline Writer& operator << (Writer& _writer, const Object& _obj)
			__DCL_THROWS1(IOException*)
{
	return _writer << _obj.toString();
}

DCLCAPI inline Writer& operator << (Writer& _writer, short int _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, unsigned short int _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, int _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, unsigned int _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, long _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, unsigned long _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, long long  _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, unsigned long long _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, float  _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, double _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

DCLCAPI inline Writer& operator << (Writer& _writer, long double _n)
__DCL_THROWS1(IOException*)
{
	return _writer << String::valueOf(_n);
}

#if __DCL_DEBUG
#undef __THIS_FILE__
#define __THIS_FILE__	__T(__FILE__)
#endif

__DCL_END_NAMESPACE

#endif	// __DCL_WRITER_H__
