#ifndef __DCL_XBYTES_OUTPUT_STREAM_H__
#define __DCL_XBYTES_OUTPUT_STREAM_H__		20110221

#ifndef __DCL_BYTES_OUTPUT_STREAM_H__
#include <dcl/BytesOutputStream.h>
#endif
#ifndef __DCL_THREAD_H__
#include <dcl/Thread.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * BytesOutputStream의 다중스레드 동기화 버전이다.
 *
 * @since	DCL Version 3.0
 *
 * @see		BytesOutputStream
 * @see		XWriter
 */

class DCLCAPI XBytesOutputStream : public BytesOutputStream
{
	DECLARE_CLASSINFO(XFileWriter)
public:
	XBytesOutputStream(size_t _capacity = 4096);

	virtual void close()
			__DCL_THROWS1(IOException*);

	virtual OutputStream& write(const void* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	virtual int vprintf(const char* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

	virtual size_t writeTo(OutputStream& _output);

	virtual size_t flushTo(OutputStream& _output)
			__DCL_THROWS1(IOException*);

	virtual void reset();

protected:
	Thread::Mutex		__lock;
};

inline XBytesOutputStream::XBytesOutputStream(size_t _capacity)
	: BytesOutputStream(_capacity)
{
}

__DCL_END_NAMESPACE

#endif		// __DCL_XBYTES_OUTPUT_STREAM_H__
