#ifndef __DCL_XFILE_OUTPUT_STREAM_H__
#define __DCL_XFILE_OUTPUT_STREAM_H__		20110218

#ifndef __DCL_FILE_OUTPUT_STREAM_H__
#include <dcl/FileOutputStream.h>
#endif
#ifndef __DCL_THREAD_H__
#include <dcl/Thread.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * FileOutputStream의 다중스레드 동기화 버전이다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		FileOutputStream
 * @see		XOutputStream
 */
class DCLCAPI XFileOutputStream : public FileOutputStream
{
	DECLARE_CLASSINFO(XFileOutputStream)
public:

	XFileOutputStream(const String& _path, bool _truncate = true)
			__DCL_THROWS1(IOException*);

	XFileOutputStream(File& __noclose__ _file)
			__DCL_THROWS1(IOException*);

	XFileOutputStream(File::HandleType __noclose__ _handle)
			__DCL_THROWS1(IOException*);

	virtual void close()
			__DCL_THROWS1(IOException*);

	virtual void flush()
			__DCL_THROWS1(IOException*);

	virtual OutputStream& write(const void* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	virtual int vprintf(const char* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

protected:
	Thread::Mutex		__lock;
};

inline XFileOutputStream::XFileOutputStream(const String& _path, bool _truncate)
		__DCL_THROWS1(IOException*)
	: FileOutputStream(_path, _truncate)
{
}

inline XFileOutputStream::XFileOutputStream(File& __noclose__ _file)
		__DCL_THROWS1(IOException*)
	: FileOutputStream(_file)
{
}

inline XFileOutputStream::XFileOutputStream(File::HandleType __noclose__ _handle)
		__DCL_THROWS1(IOException*)
	:  FileOutputStream(_handle)
{
}

__DCL_END_NAMESPACE

#endif		// __DCL_XFILE_OUTPUT_STREAM_H__
