#ifndef __DCL_XFILE_WRITER_H__
#define __DCL_XFILE_WRITER_H__		20110218

#ifndef __DCL_FILE_WRITER_H__
#include <dcl/FileWriter.h>
#endif
#ifndef __DCL_THREAD_H__
#include <dcl/Thread.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * FileWriter의 다중스레드 동기화 버전이다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		FileWriter
 * @see		XWriter
 */
class DCLCAPI XFileWriter : public FileWriter
{
	DECLARE_CLASSINFO(XFileWriter)
public:

	XFileWriter(const String& _path, bool _truncate, CharsetEncoder* _pEncoder = NULL)
			__DCL_THROWS1(IOException*);

	XFileWriter(File& __noclose__ _file, CharsetEncoder* _pEncoder = NULL)
			__DCL_THROWS1(IOException*);

	XFileWriter(File::HandleType __noclose__ _handle, CharsetEncoder* _pEncoder = NULL)
			__DCL_THROWS1(IOException*);

	virtual void close()
			__DCL_THROWS1(IOException*);

	virtual void flush()
			__DCL_THROWS1(IOException*);

	virtual Writer& write(const wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	virtual int vprintf(const wchar_t* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

protected:
	Thread::Mutex		__lock;
};

inline XFileWriter::XFileWriter(const String& _path, bool _truncate, CharsetEncoder* _pEncoder)
		__DCL_THROWS1(IOException*)
	: FileWriter(_path, _truncate, _pEncoder)
{
}

inline XFileWriter::XFileWriter(File& __noclose__ _file, CharsetEncoder* _pEncoder)
		__DCL_THROWS1(IOException*)
	: FileWriter(_file, _pEncoder)
{
}

inline XFileWriter::XFileWriter(File::HandleType __noclose__ _handle, CharsetEncoder* _pEncoder)
		__DCL_THROWS1(IOException*)
	:  FileWriter(_handle, _pEncoder)
{
}

__DCL_END_NAMESPACE

#endif		// __DCL_XFILE_WRITER_H__
