#ifndef __DCL_XOUTPUT_STREAM_H__
#define __DCL_XOUTPUT_STREAM_H__		20071009

#ifndef __DCL_OUTPUT_STREAM_H__
#include <dcl/OutputStream.h>
#endif
#ifndef __DCL_THREAD_H__
#include <dcl/Thread.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * {@link OutputStream} 인터페이스의 다중스레드 동기화를 제공한다.
 * <p>동기화는 OutputStream의 기본 메소드인  {@link #close()}, {@link #flush()},
 *	 {@link #write(constchar_t*,size_t) write(const char_t* _buf, size_t _nbytes)},
 *	 {@link #vprintf(constchar_t*,va_list) vprintf(const char_t* _format, va_list _arglist)} 이다.
 * </p>
 * <p>이들 메소드는 다음과 같이 구현되어 있다.</p>
 * <pre>
 *	OutputStream& XOutputStream::write(const char_t* _buf, size_t _nbytes)
 *	{
 *    if (__output)
 *    {
 *	      Thread::SingleLockMutex lockAndUnlock(__lock);
 *	      __output->write(_buf, _n);
 *    }
 *    return *this;
 *	}
 *</pre>
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		OutputStream
 */
class DCLCAPI XOutputStream : public OutputStream
{
	DECLARE_CLASSINFO(XOutputStream)
public:
	/**
	 * 객체의 구성에 대하여 간략한 요약을 반환한다.
	 */
	virtual String toString() const;

	/**
	 * 객체를 구성한다.
	 * @param _pOutput
	 *		동기화할 OutputStream의 인스턴스이다. NULL 이면, {@link close()}, {@link flush()},
	 *		{@link write(constwchar_t*,size_t) write(const wchar_t* _buf, size_t _n)},
	 *		{@link vprintf(constwchar_t*,va_list) vprintf(const wchar_t* _format, va_list _arglist)}
	 *		는 아무런 행위를 하지 않는다.
	 */
	XOutputStream(OutputStream* __destroy__ _pOutput);

	/**
	 * 출력 OutputStream 객체를 설정한다.
	 * @param _pOutput
	 *		동기화할 Writer의 인스턴스이다. NULL 이면, {@link close()}, {@link flush()},
	 *		{@link write(constwchar_t*,size_t) write(const wchar_t* _buf, size_t _n)},
	 *		{@link vprintf(constwchar_t*,va_list) vprintf(const wchar_t* _format, va_list _arglist)}
	 *		는 아무런 행위를 하지 않는다.
	 * @return
	 *		이전에 설정한 OutputStream를 반환한다.
	 */
	OutputStream* setOutputStream(OutputStream* __destroy__ _pOutput);

	/**
	 * 객체의 파괴를 수행한다.
	 * {@link close()}를 호출한다.
	*/
	virtual ~XOutputStream();

	/**
	 * 설정된 OutputStream 객체를 닫고, 파괴(destroy)한다.
	 * 
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 * 설정된 OutputStream의 flush()를 호출한다.
	 */
	virtual void flush()
			__DCL_THROWS1(IOException*);

	/**
	 * _n바이트의 데이터를 스트림에 write한다.
	 */
	virtual OutputStream& write(const void* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	/**
	 * 형식화된 문자열을 출력한다.
	 */
	virtual int vprintf(const char* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

private:
	OutputStream*		__output;
	Thread::Mutex		__lock;
};

__DCL_END_NAMESPACE

#endif		// __DCL_XOUTPUT_STREAM_H__
