#ifndef __DCL_XOUTPUT_STREAM_WRITER_H__
#define __DCL_XOUTPUT_STREAM_WRITER_H__		20110218

#ifndef __DCL_OUTPUT_STREAM_WRITER_H__
#include <dcl/OutputStreamWriter.h>
#endif
#ifndef __DCL_THREAD_H__
#include <dcl/Thread.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * OutputStreamWriter의 다중스레드 동기화 버전이다.
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		OutputStreamWriter
 * @see		XWriter
 */

class DCLCAPI XOutputStreamWriter : public OutputStreamWriter
{
	DECLARE_CLASSINFO(XOutputStreamWriter)
public:
	XOutputStreamWriter(
		OutputStream&		__noclose__ _output,
		CharsetEncoder&	_encoder
		);

	XOutputStreamWriter(
		OutputStream*		__destroy__ _pOutput,				// new OutputStream
		CharsetEncoder*	__destroy__ _pEncoder = NULL	// new CharsetEncoder
		) __DCL_THROWS1(IOException*);

	virtual void close()
			__DCL_THROWS1(IOException*);

	virtual void flush()
			__DCL_THROWS1(IOException*);

	virtual Writer& write(const wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	virtual int vprintf(const wchar_t* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

protected:
	Thread::Mutex		__lock;
};

inline XOutputStreamWriter::XOutputStreamWriter(
		OutputStream& _output,
		CharsetEncoder& _encoder
		)
	: OutputStreamWriter(_output, _encoder)
{
}

inline XOutputStreamWriter::XOutputStreamWriter(
		OutputStream*		_pOutput,	
		CharsetEncoder*	_pEncoder
		)
	: OutputStreamWriter(_pOutput, _pEncoder)
{
}

__DCL_END_NAMESPACE

#endif		// __DCL_XOUTPUT_STREAM_WRITER_H__
