#ifndef __DCL_XSTRING_WRITER_H__
#define __DCL_XSTRING_WRITER_H__		20110221

#ifndef __DCL_STRING_WRITER_H__
#include <dcl/StringWriter.h>
#endif
#ifndef __DCL_THREAD_H__
#include <dcl/Thread.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * StringWriter의 다중스레드 동기화 버전이다.
 *
 * @since		DCL Version 3.0
 *
 * @see		StringWriter
 * @see		XWriter
 */

class DCLCAPI XStringWriter : public StringWriter
{
	DECLARE_CLASSINFO(XFileWriter)
public:
	XStringWriter(size_t _initial = 4096);

	virtual void close()
			__DCL_THROWS1(IOException*);

	virtual Writer& write(const wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	virtual int vprintf(const wchar_t* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

	virtual size_t writeTo(Writer& _writer);

	virtual size_t flushTo(Writer& _writer)
			__DCL_THROWS1(IOException*);

	virtual void reset();

protected:
	Thread::Mutex		__lock;
};

inline XStringWriter::XStringWriter(size_t _initial)
	: StringWriter(_initial)
{
}

__DCL_END_NAMESPACE

#endif		// __DCL_XSTRING_WRITER_H__
