#ifndef __DCL_XWRITER_H__
#define __DCL_XWRITER_H__			20110218

#ifndef __DCL_WRITER_H__
#include <dcl/Writer.h>
#endif
#ifndef __DCL_THREAD_H__
#include <dcl/Thread.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * {@link Writer} 인터페이스의 다중스레드 동기화를 제공한다.
 * <p>동기화는 Writer의 기본 메소드인  {@link #close()}, {@link #flush()},
 *	 {@link #write(constwchar_t*,size_t) write(const wchar_t* _buf, size_t _n)},
 *	 {@link #vprintf(constwchar_t*,va_list) vprintf(const wchar_t* _format, va_list _arglist)} 이다.
 * </p>
 * <p>이들 메소드는 다음과 같이 구현되어 있다.</p>
 * <pre>
 *	Writer& XWriter::write(const wchar_t* _buf, size_t _n)
 *	{
 *    if (__writer)
 *    {
 *	      Thread::SingleLockMutex lockAndUnlock(__lock);
 *	      __writer->write(_buf, _n);
 *    }
 *    return *this;
 *	}
 *</pre>
 *
 * @author	Daejung Kim
 * @since		DCL Version 3.0
 *
 * @see		Writer
 */
class DCLCAPI XWriter : public Writer
{
	DECLARE_CLASSINFO(XWriter)
public:
	/**
	 * 객체의 구성에 대하여 간략한 요약을 반환한다.
	 */
	virtual String toString() const;

	/**
	 * 객체를 구성한다.
	 * @param _pWriter
	 *		동기화할 Writer의 인스턴스이다. NULL 이면, {@link close()}, {@link flush()},
	 *		{@link write(constwchar_t*,size_t) write(const wchar_t* _buf, size_t _n)},
	 *		{@link vprintf(constwchar_t*,va_list) vprintf(const wchar_t* _format, va_list _arglist)}
	 *		는 아무런 행위를 하지 않는다.
	 */
	XWriter(Writer* __destroy__ _pWriter);

	/**
	 * 출력 Writer 객체를 설정한다.
	 * @param _pWriter
	 *		동기화할 Writer의 인스턴스이다. NULL 이면, {@link close()}, {@link flush()},
	 *		{@link write(constwchar_t*,size_t) write(const wchar_t* _buf, size_t _n)},
	 *		{@link vprintf(constwchar_t*,va_list) vprintf(const wchar_t* _format, va_list _arglist)}
	 *		는 아무런 행위를 하지 않는다.
	 * @return
	 *		이전에 설정한 Writer를 반환한다.
	 */
	Writer* setWriter(Writer* __destroy__ _pWriter);

	/**
	 * 객체의 파괴를 수행한다.
	 * {@link close()}를 호출한다.
	*/
	virtual ~XWriter();

	/**
	 * 설정된 Writer 객체를 닫고, 파괴(destroy)한다.
	 * 
	 */
	virtual void close()
			__DCL_THROWS1(IOException*);

	/**
	 * 설정된 Writer의 flush()를 호출한다.
	 */
	virtual void flush()
			__DCL_THROWS1(IOException*);

	/**
	 * _n개의 wchar_t 문자를 쓴다(write).
	 * <p>파생클래스는 _n개의 wchar_t 문자를 write하는 것에 대하여 보장하도록 구현해야 한다.</p>
	 *
	 * @param _buf
	 *		버퍼
	 * @param _n
	 *		버퍼의 wchar_t 문자개수가 _n개
	 * @return
	 *		Writer&
	 */
	virtual Writer& write(const wchar_t* _buf, size_t _n)
			__DCL_THROWS1(IOException*);

	/**
	 * 형식화된 문자열을 출력한다.
	 * @param _format
	 *		포멧 문자열
	 * @param _arglist
	 *		아귀먼트 리스트
	 * @return
	 *		출력된 총 문자의 개수를 반환한다.
	 */
	virtual int vprintf(const wchar_t* _format, va_list _arglist)
			__DCL_THROWS1(IOException*);

protected:
	Writer*				__writer;
	Thread::Mutex		__lock;
};
__DCL_END_NAMESPACE

#endif			// __DCL_XWRITER_H__
