#ifdef __DCL_INTERNAL__

__DCL_BEGIN_NAMESPACE

#ifdef __COMPILE_StringToStringMap__
	#define THIS_NAME						__szStringToStringMap_h__
	#define THIS_VALUE						__T("dcl/__HASHMAP.h/StringToStringMap")
	#define HASHMAP_T						StringToStringMap
	#define HASHFUN_T						HashFun<String>
	#define KEY_T							String
	#define VALUE_T							String
	#define HAVE_CONSTRUCTOR_KEY			1
	#define HAVE_CONSTRUCTOR_VALUE			1
#elif defined(__COMPILE_StringToPointerMap__)
	#define THIS_NAME						__szStringToPointerMap_h__
	#define THIS_VALUE						__T("dcl/__HASHMAP.h/StringToPointerMap")
	#define HASHMAP_T						StringToPointerMap
	#define HASHFUN_T						HashFun<String>
	#define KEY_T							String
	#define VALUE_T							void*
	#define HAVE_CONSTRUCTOR_KEY			1
	#define HAVE_CONSTRUCTOR_VALUE			0
#elif defined(__COMPILE_IntToPointerMap__)
	#define THIS_NAME						__szIntToPointerMap_h__
	#define THIS_VALUE						__T("dcl/__HASHMAP.h/IntToPointerMap")
	#define HASHMAP_T						IntToPointerMap
	#define HASHFUN_T						HashFun<int>
	#define KEY_T							int
	#define VALUE_T							void*
	#define HAVE_CONSTRUCTOR_KEY			0
	#define HAVE_CONSTRUCTOR_VALUE			0
#endif

#if __DCL_HAVE_THIS_FILE__
	static const char_t THIS_NAME[] = THIS_VALUE;
	#undef __THIS_FILE__
	#define __THIS_FILE__ THIS_NAME
#endif

/**
 * template class HashMap의 DSO 호환성을 제공한다.
 * <p>C++의 template class는 해당 코드를 사용하기 전에는 실제 이진 코드를 생성하지 않으므로,
 * DSO(so, DLL)와 DSO, 또는 실행파일에서 객체를 주고받을 수 없다.<p>
 * <p>이 클래스는 DSO의 이러한 문제를 해결하며,
 * 포함파일은 <code>&lt;dcl/HashMap.h&gt;</code>이다.</p>
 * <p>이 코드를 사용하는 클래스는 다음과 같다.</p>
 * <ul>
 *      <li>class DCLCAPI StringToStringMap</li>
 *      <li>class DCLCAPI StringToPointerMap</li>
 *      <li>class DCLCAPI IntToIntMap</li>
 * </ul>
 *
 * @see HashMap
 */
class DCLCAPI HASHMAP_T : public Object
{
	DECLARE_CLASSINFO(HASHMAP_T)
public:
	virtual String toString() const;

public:
	struct Assoc
	{
		KEY_T			key;
		VALUE_T		value;

		Assoc() {}
		Assoc(const KEY_T& _key, const VALUE_T& _value)
		{
			this->key = _key;
			this->value = (VALUE_T) _value;
		}
	};

	struct HashNode : public Assoc
	{
		HashNode* pNext;
	};

	class ConstIterator;
	class Iterator
	{
	public:
		Iterator(HashNode* _pNode, HASHMAP_T* _pMap);
		Iterator& operator=(const Iterator& _it);
		Iterator& operator++();
		Iterator operator++(int);
		bool operator==(const Iterator& _it) const;
		bool operator!=(const Iterator& _it) const;
		Assoc& operator*() const;
	protected:
		HASHMAP_T*	__pMap;
		HashNode*	__pNode;
		friend class ConstIterator;
	};

	class ConstIterator
	{
	public:
		ConstIterator(const HashNode* _pNode, const HASHMAP_T* _pMap);
		ConstIterator(const ConstIterator& _it);
		ConstIterator(const Iterator& _it);
		ConstIterator& operator=(const ConstIterator& _it);
		ConstIterator& operator++();
		ConstIterator operator++(int);
		bool operator==(const ConstIterator& _it) const;
		bool operator!=(const ConstIterator& _it) const;
		const Assoc& operator*() const;
	protected:
		const HASHMAP_T*	__pMap;
		const HashNode*	__pNode;
	};

public:
	virtual ~HASHMAP_T();
	HASHMAP_T(size_t _bucketSize = 21);
	void initBuckets(size_t _bucketSize);

	HASHMAP_T(const HASHMAP_T& _src);
	const HASHMAP_T& operator=(const HASHMAP_T& _src);

	ConstIterator begin() const;
	ConstIterator end() const;
	Iterator begin();
	Iterator end();
	size_t bucketSize() const;
	size_t size() const;
	size_t sizeOfBucket(size_t _index) const;
	bool isEmpty() const;
	Iterator find(const KEY_T& _key);
	ConstIterator find(const KEY_T& _key) const;
	bool lookup(const KEY_T& _key, VALUE_T& _rValue) const;
	VALUE_T& operator[](const KEY_T&  _key);
	size_t erase(const KEY_T& _key);
	void clear();

protected:
	size_t bucketIndex(const KEY_T& _key) const;
	HashNode* createNode(const KEY_T& _key);
	void destroyNode(HashNode* _pNode);

protected:
	HASHFUN_T		__hashFun;
	size_t				__size;			// count of all elements
	PointerArray		__buckets;

	friend class Iterator;
	friend class ConstIterator;
};

//////////////// Inline HashMap::Iterator ////////////////

inline
HASHMAP_T
::Iterator::Iterator(
		HashNode* _pNode,
		HASHMAP_T* _pMap
		)
{
	__pNode = _pNode;
	__pMap = _pMap;
}

inline
HASHMAP_T::Iterator&
HASHMAP_T
::Iterator::operator = (const Iterator& _it)
{
	__pNode = _it.__pNode;
	__pMap = _it.__pMap;
	return *this;
}

inline
bool 
HASHMAP_T
::Iterator::operator == (const Iterator& _it) const
{
	return __pNode == _it.__pNode;
}

inline
bool
HASHMAP_T
::Iterator::operator != (const Iterator& _it) const
{
	return __pNode != _it.__pNode;
}

inline
HASHMAP_T::Assoc& 
HASHMAP_T::Iterator::operator*()const
{
	return *__pNode;
}

/////////////////// Inline HashMap::ConstIterator ///////////

inline
HASHMAP_T
::ConstIterator::ConstIterator(
			const HashNode* _pNode,
			const HASHMAP_T* _pMap
			)
{
	__pNode = _pNode;
	__pMap = _pMap;
}

inline
HASHMAP_T
::ConstIterator::ConstIterator(const ConstIterator& _it)
{
	__pNode = _it.__pNode;
	__pMap = _it.__pMap;
}

inline
HASHMAP_T
::ConstIterator::ConstIterator(const Iterator& _it)
{
	__pNode = _it.__pNode;
	__pMap = _it.__pMap;
}

inline
HASHMAP_T::ConstIterator&
HASHMAP_T
::ConstIterator::operator=(const ConstIterator& _it)
{
	__pNode = _it.__pNode;
	__pMap = _it.__pMap;
	return *this;
}

inline
bool
HASHMAP_T
::ConstIterator::operator == (const ConstIterator& _it) const
{
	return __pNode == _it.__pNode;
}

inline
bool
HASHMAP_T
::ConstIterator::operator != (const ConstIterator& _it) const
{
	return __pNode != _it.__pNode;
}

inline
const HASHMAP_T::Assoc&
HASHMAP_T
::ConstIterator::operator*() const
{
	return *__pNode;
}

/////////////////// Inline HashMap //////////////

inline
HASHMAP_T::Iterator
HASHMAP_T::end()
{
	return Iterator(NULL, this);
}

inline
HASHMAP_T::ConstIterator
HASHMAP_T::end() const
{
	return ConstIterator(NULL, this);
}

inline
size_t
HASHMAP_T::bucketSize() const
{
	return __buckets.size();
}

inline
size_t
HASHMAP_T::size() const
{
	return __size;
}

inline
bool
HASHMAP_T::isEmpty() const
{
	return __size == 0;
}

#if __DCL_HAVE_THIS_FILE__
	#undef __THIS_FILE__
	#define __THIS_FILE__	__T(__FILE__)
#endif

#undef THIS_NAME
#undef THIS_VALUE
#undef HASHMAP_T
#undef HASHFUN_T
#undef KEY_T
#undef VALUE_T
#undef HAVE_CONSTRUCTOR_KEY
#undef HAVE_CONSTRUCTOR_VALUE

__DCL_END_NAMESPACE

#endif			// __DCL_INTERNAL__
