#ifdef __DCL_INTERNAL__

#ifdef __COMPILE_StringList__
	#define THIS_NAME						__szStringList_h__
	#define THIS_VALUE						__T("dcl/__LIST.h/String")
	#define LIST_T							StringList
	#define ELEMENT_T						String
	#define ELEMENT_T_CAST
	#define CONST_ELEMENT_REF				const String&
	#define HAVE_CONSTRUCTOR_ELEMENT		1
#elif defined(__COMPILE_ByteStringList__)
	#define THIS_NAME						__szByteStringList_h__
	#define THIS_VALUE						__T("dcl/__LIST.h/ByteString")
	#define LIST_T							ByteStringList
	#define ELEMENT_T						ByteString
	#define ELEMENT_T_CAST
	#define CONST_ELEMENT_REF				const ByteString&
	#define HAVE_CONSTRUCTOR_ELEMENT		1
#elif defined(__COMPILE_PointerList__)
	#define THIS_NAME						__szPointerList_h__
	#define THIS_VALUE						__T("dcl/__LIST.h/void*")
	#define LIST_T							PointerList
	#define ELEMENT_T						void*
	#define ELEMENT_T_CAST					(void*)
	#define CONST_ELEMENT_REF				const void*
	#define HAVE_CONSTRUCTOR_ELEMENT		0
#endif

#if __DCL_HAVE_THIS_FILE__
	static const char_t THIS_NAME[] = THIS_VALUE;
	#undef __THIS_FILE__
	#define __THIS_FILE__ THIS_NAME
#endif

/**
 * template class List의 DSO 호환성을 제공한다.
 * <p>C++의 template class는 해당 코드를 사용하기 전에는 실제 이진 코드를 생성하지 않으므로,
 * DSO(so, DLL)와 DSO, 또는 실행파일에서 객체를 주고받을 수 없다.<p>
 * <p>이 클래스는 DSO의 이러한 문제를 해결하며,
 * 포함파일은 <code>&lt;dcl/List.h&gt;</code>이다.</p>
 * <p>이 코드를 사용하는 클래스는 다음과 같다.</p>
 * <ul>
 *      <li>class DCLCAPI StringList</li>
 *      <li>class DCLCAPI ByteStringList</li>
 *      <li>class DCLCAPI PointerList</li>
 * </ul>
 *
 * @see List
 */

class DCLCAPI LIST_T : public Object
{
	DECLARE_CLASSINFO(List)
public:
	virtual String toString() const;

public:
	struct ListNode : public NodeBase
	{
		ELEMENT_T	data;
	};
	
	class ConstIterator;
	class Iterator : public ListIteratorBase
	{
	public:
		Iterator();
		Iterator(NodeBase* _pNode);
		Iterator(const Iterator& _it);
		Iterator& operator=(const Iterator& _it);
		Iterator& operator++();
		Iterator operator++(int);
		Iterator& operator--();
		Iterator operator--(int);
		ELEMENT_T& operator*();

	protected:
		friend class LIST_T;
		friend class ConstIterator;
	};

	class ConstIterator : public ConstListIteratorBase
	{
	public:
		ConstIterator();
		ConstIterator(const NodeBase* _pNode);
		ConstIterator(const ConstIterator& _it);
		ConstIterator(const Iterator& _it);
		ConstIterator& operator=(const ConstIterator& _it);
		ConstIterator& operator++();
		ConstIterator operator++(int);
		ConstIterator& operator--();
		ConstIterator operator--(int);
		CONST_ELEMENT_REF operator*();
	};

	class ReverseConstIterator;
	class ReverseIterator : public ListIteratorBase
	{
	public:
		ReverseIterator();
		ReverseIterator(NodeBase* _pNode);
		ReverseIterator(const ReverseIterator& _it);
		ReverseIterator& operator=(const ReverseIterator& _it);
		ReverseIterator& operator++();
		ReverseIterator operator++(int);
		ReverseIterator& operator--();
		ReverseIterator operator--(int);
		ELEMENT_T& operator*();

	protected:
		friend class LIST_T;
		friend class ReverseConstIterator;
	};

	class ReverseConstIterator : public ConstListIteratorBase
	{
	public:
		ReverseConstIterator();
		ReverseConstIterator(const NodeBase* _pNode);
		ReverseConstIterator(const ReverseConstIterator& _it);
		ReverseConstIterator(const ReverseIterator& _it);
		ReverseConstIterator& operator=(const ReverseConstIterator& _it);
		ReverseConstIterator& operator++();
		ReverseConstIterator operator++(int);
		ReverseConstIterator& operator--();
		ReverseConstIterator operator--(int);
		CONST_ELEMENT_REF operator*();
	};

public:
	virtual ~LIST_T();
	LIST_T();
	LIST_T(const LIST_T& _src);
	const LIST_T& operator=(const LIST_T& _src);

	ConstIterator begin() const;
	ConstIterator end() const;
	Iterator begin();
	Iterator end();

	ReverseConstIterator rbegin() const;
	ReverseConstIterator rend() const;
	ReverseIterator rbegin();
	ReverseIterator rend();

	// return is current Iterator
	Iterator insert(Iterator _pos, CONST_ELEMENT_REF _element);
	void insert(Iterator _pos, ConstIterator _first, ConstIterator _last);

	Iterator find(CONST_ELEMENT_REF _element);
	
	// return is next Iterator	
	Iterator erase(Iterator _pos);
	void splice(Iterator _pos, LIST_T& _other, Iterator _otherFirst, Iterator _otherLast);
	
	LIST_T& add(CONST_ELEMENT_REF _element);
	LIST_T& addHead(CONST_ELEMENT_REF _element);
	LIST_T& addTail(CONST_ELEMENT_REF _element);

	ELEMENT_T removeHead();
	ELEMENT_T removeTail();

	void clear();
	bool isEmpty() const;
	size_t size() const;

protected:
	NodeBase*	__pMasterNode;
	size_t			__size;

	size_t	size(ConstIterator _first, ConstIterator _last) const;
	// _first ~ _last to posTo
	void move(Iterator posTo, Iterator _first, Iterator _last);

	ListNode* createNode(CONST_ELEMENT_REF _element);
	void destroyNode(ListNode* _pNode);
};

////////////// Inline List::Iterator ///////////////

inline
LIST_T::Iterator::Iterator()
{
	__pNode = NULL;
}

inline
LIST_T::Iterator::Iterator(NodeBase* _pNode)
{
	__DCL_ASSERT(_pNode != NULL);
	__pNode = _pNode;
}

inline
LIST_T::Iterator::Iterator(const Iterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LIST_T::Iterator&
LIST_T::Iterator::operator=(const Iterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
	return *this;
}

inline
LIST_T::Iterator&
LIST_T::Iterator::operator++()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pNext;
	return *this;
}

inline
LIST_T::Iterator
LIST_T::Iterator::operator++(int)
{
	__DCL_ASSERT(__pNode != NULL);
	NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pNext;
	return Iterator(pSaveNode);
}

inline
LIST_T::Iterator&
LIST_T::Iterator::operator--()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pPrev;
	return *this;
}

inline
LIST_T::Iterator
LIST_T::Iterator::operator--(int)
{
	__DCL_ASSERT(__pNode != NULL);
	NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pPrev;
	return Iterator(pSaveNode);
}

inline
ELEMENT_T&
LIST_T::Iterator::operator * ()
{
	__DCL_ASSERT(__pNode != NULL);
	return ((ListNode*)__pNode)->data;
}

////////////// Inline List::ConstIterator ///////////////

inline
LIST_T::ConstIterator::ConstIterator()
{
	__pNode = NULL;
}

inline
LIST_T::ConstIterator::ConstIterator(const NodeBase* _pNode)
{
	__DCL_ASSERT(_pNode != NULL);
	__pNode = _pNode;
}

inline
LIST_T::ConstIterator::ConstIterator(const ConstIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LIST_T::ConstIterator::ConstIterator(const Iterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LIST_T::ConstIterator&
LIST_T::ConstIterator::operator=(const ConstIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
	return *this;
}

inline
LIST_T::ConstIterator&
LIST_T::ConstIterator::operator++()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pNext;
	return *this;
}

inline
LIST_T::ConstIterator
LIST_T::ConstIterator::operator++(int)
{
	__DCL_ASSERT(__pNode != NULL);
	const NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pNext;
	return ConstIterator(pSaveNode);
}

inline
LIST_T::ConstIterator&
LIST_T::ConstIterator::operator--()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pPrev;
	return *this;
}

inline
LIST_T::ConstIterator
LIST_T::ConstIterator::operator--(int)
{
	__DCL_ASSERT(__pNode != NULL);
	const NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pPrev;
	return ConstIterator(pSaveNode);
}

inline
CONST_ELEMENT_REF
LIST_T::ConstIterator::operator * ()
{
	__DCL_ASSERT(__pNode != NULL);
	return ((ListNode*)__pNode)->data;
}

////////////// Inline List::ReverseIterator ///////////////

inline
LIST_T::ReverseIterator::ReverseIterator()
{
	__pNode = NULL;
}

inline
LIST_T::ReverseIterator::ReverseIterator(NodeBase* _pNode)
{
	__DCL_ASSERT(_pNode != NULL);
	__pNode = _pNode;
}

inline
LIST_T::ReverseIterator::ReverseIterator(const ReverseIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LIST_T::ReverseIterator&
LIST_T::ReverseIterator::operator=(const ReverseIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
	return *this;
}

inline
LIST_T::ReverseIterator&
LIST_T::ReverseIterator::operator++()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pPrev;
	return *this;
}

inline
LIST_T::ReverseIterator
LIST_T::ReverseIterator::operator++(int)
{
	__DCL_ASSERT(__pNode != NULL);
	NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pPrev;
	return ReverseIterator(pSaveNode);
}

inline
LIST_T::ReverseIterator&
LIST_T::ReverseIterator::operator--()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pNext;
	return *this;
}

inline
LIST_T::ReverseIterator
LIST_T::ReverseIterator::operator--(int)
{
	__DCL_ASSERT(__pNode != NULL);
	NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pNext;
	return ReverseIterator(pSaveNode);
}

inline
ELEMENT_T&
LIST_T::ReverseIterator::operator * ()
{
	__DCL_ASSERT(__pNode != NULL);
	return ((ListNode*)__pNode)->data;
}

////////////// Inline List::ReverseConstIterator ///////////////

inline
LIST_T::ReverseConstIterator::ReverseConstIterator()
{
	__pNode = NULL;
}

inline
LIST_T::ReverseConstIterator::ReverseConstIterator(const NodeBase* _pNode)
{
	__DCL_ASSERT(_pNode != NULL);
	__pNode = _pNode;
}

inline
LIST_T::ReverseConstIterator::ReverseConstIterator(const ReverseConstIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LIST_T::ReverseConstIterator::ReverseConstIterator(const ReverseIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LIST_T::ReverseConstIterator&
LIST_T::ReverseConstIterator::operator=(const ReverseConstIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
	return *this;
}

inline
LIST_T::ReverseConstIterator&
LIST_T::ReverseConstIterator::operator++()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pPrev;
	return *this;
}

inline
LIST_T::ReverseConstIterator
LIST_T::ReverseConstIterator::operator++(int)
{
	__DCL_ASSERT(__pNode != NULL);
	const NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pPrev;
	return ReverseConstIterator(pSaveNode);
}

inline
LIST_T::ReverseConstIterator&
LIST_T::ReverseConstIterator::operator--()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pNext;
	return *this;
}

inline
LIST_T::ReverseConstIterator
LIST_T::ReverseConstIterator::operator--(int)
{
	__DCL_ASSERT(__pNode != NULL);
	const NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pNext;
	return ReverseConstIterator(pSaveNode);
}

inline
CONST_ELEMENT_REF
LIST_T::ReverseConstIterator::operator * ()
{
	__DCL_ASSERT(__pNode != NULL);
	return ((ListNode*)__pNode)->data;
}

////////////// Inline List ////////////////////

inline
LIST_T::ConstIterator
LIST_T::begin() const
{
	return __pMasterNode->pNext;
}

inline
LIST_T::ConstIterator
LIST_T::end() const
{
	return __pMasterNode;
}

inline
LIST_T::Iterator
LIST_T::begin()
{
	return __pMasterNode->pNext;
}

inline
LIST_T::Iterator
LIST_T::end()
{
	return __pMasterNode;
}

inline
LIST_T::ReverseConstIterator
LIST_T::rbegin() const
{
	return __pMasterNode->pPrev;
}

inline
LIST_T::ReverseConstIterator
LIST_T::rend() const
{
	return __pMasterNode;
}

inline
LIST_T::ReverseIterator
LIST_T::rbegin()
{
	return __pMasterNode->pPrev;
}

inline
LIST_T::ReverseIterator
LIST_T::rend()
{
	return __pMasterNode;
}

inline
bool
LIST_T::isEmpty() const
{
	return __pMasterNode->pNext == __pMasterNode;
}

inline
size_t
LIST_T::size() const
{
	return __size;
}

inline
LIST_T&
LIST_T::addHead(CONST_ELEMENT_REF _element)
{
	insert(begin(), _element);
	return *this;
}

inline
LIST_T&
LIST_T::addTail(CONST_ELEMENT_REF _element)
{
	insert(end(), _element);
	return *this;
}

inline
LIST_T&
LIST_T::add(CONST_ELEMENT_REF _element)
{
	insert(end(), _element);
	return *this;
}

#if __DCL_HAVE_THIS_FILE__
	#undef __THIS_FILE__
	#define __THIS_FILE__	__T(__FILE__)
#endif

#undef THIS_NAME
#undef THIS_VALUE
#undef LIST_T
#undef ELEMENT_T
#undef ELEMENT_T_CAST
#undef CONST_ELEMENT_REF
#undef HAVE_CONSTRUCTOR_ELEMENT

#endif			// __DCL_INTERNAL__
